package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.costexplorer.{ CostExplorerAsyncClient, CostExplorerAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object costexplorer {
  type CostExplorer = Has[CostExplorer.Service]
  object CostExplorer {
    trait Service extends AspectSupport[Service] {
      val api: CostExplorerAsyncClient
      def updateAnomalySubscription(request: model.UpdateAnomalySubscriptionRequest): IO[AwsError, model.UpdateAnomalySubscriptionResponse.ReadOnly]
      def createAnomalySubscription(request: model.CreateAnomalySubscriptionRequest): IO[AwsError, model.CreateAnomalySubscriptionResponse.ReadOnly]
      def getCostAndUsageWithResources(request: model.GetCostAndUsageWithResourcesRequest): IO[AwsError, model.GetCostAndUsageWithResourcesResponse.ReadOnly]
      def updateAnomalyMonitor(request: model.UpdateAnomalyMonitorRequest): IO[AwsError, model.UpdateAnomalyMonitorResponse.ReadOnly]
      def deleteCostCategoryDefinition(request: model.DeleteCostCategoryDefinitionRequest): IO[AwsError, model.DeleteCostCategoryDefinitionResponse.ReadOnly]
      def getSavingsPlansPurchaseRecommendation(request: model.GetSavingsPlansPurchaseRecommendationRequest): IO[AwsError, model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly]
      def getSavingsPlansCoverage(request: model.GetSavingsPlansCoverageRequest): ZStream[Any, AwsError, model.SavingsPlansCoverage.ReadOnly]
      def getSavingsPlansUtilization(request: model.GetSavingsPlansUtilizationRequest): IO[AwsError, model.GetSavingsPlansUtilizationResponse.ReadOnly]
      def createCostCategoryDefinition(request: model.CreateCostCategoryDefinitionRequest): IO[AwsError, model.CreateCostCategoryDefinitionResponse.ReadOnly]
      def createAnomalyMonitor(request: model.CreateAnomalyMonitorRequest): IO[AwsError, model.CreateAnomalyMonitorResponse.ReadOnly]
      def getSavingsPlansUtilizationDetails(request: model.GetSavingsPlansUtilizationDetailsRequest): ZIO[Any, AwsError, StreamingOutputResult[Any, model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly, model.SavingsPlansUtilizationDetail.ReadOnly]]
      def getCostCategories(request: model.GetCostCategoriesRequest): IO[AwsError, model.GetCostCategoriesResponse.ReadOnly]
      def getReservationPurchaseRecommendation(request: model.GetReservationPurchaseRecommendationRequest): IO[AwsError, model.GetReservationPurchaseRecommendationResponse.ReadOnly]
      def getUsageForecast(request: model.GetUsageForecastRequest): IO[AwsError, model.GetUsageForecastResponse.ReadOnly]
      def getDimensionValues(request: model.GetDimensionValuesRequest): IO[AwsError, model.GetDimensionValuesResponse.ReadOnly]
      def getReservationUtilization(request: model.GetReservationUtilizationRequest): IO[AwsError, model.GetReservationUtilizationResponse.ReadOnly]
      def deleteAnomalyMonitor(request: model.DeleteAnomalyMonitorRequest): IO[AwsError, model.DeleteAnomalyMonitorResponse.ReadOnly]
      def getCostAndUsage(request: model.GetCostAndUsageRequest): IO[AwsError, model.GetCostAndUsageResponse.ReadOnly]
      def deleteAnomalySubscription(request: model.DeleteAnomalySubscriptionRequest): IO[AwsError, model.DeleteAnomalySubscriptionResponse.ReadOnly]
      def getCostForecast(request: model.GetCostForecastRequest): IO[AwsError, model.GetCostForecastResponse.ReadOnly]
      def listCostCategoryDefinitions(request: model.ListCostCategoryDefinitionsRequest): ZStream[Any, AwsError, model.CostCategoryReference.ReadOnly]
      def getAnomalySubscriptions(request: model.GetAnomalySubscriptionsRequest): IO[AwsError, model.GetAnomalySubscriptionsResponse.ReadOnly]
      def getAnomalies(request: model.GetAnomaliesRequest): IO[AwsError, model.GetAnomaliesResponse.ReadOnly]
      def getRightsizingRecommendation(request: model.GetRightsizingRecommendationRequest): IO[AwsError, model.GetRightsizingRecommendationResponse.ReadOnly]
      def provideAnomalyFeedback(request: model.ProvideAnomalyFeedbackRequest): IO[AwsError, model.ProvideAnomalyFeedbackResponse.ReadOnly]
      def updateCostCategoryDefinition(request: model.UpdateCostCategoryDefinitionRequest): IO[AwsError, model.UpdateCostCategoryDefinitionResponse.ReadOnly]
      def getReservationCoverage(request: model.GetReservationCoverageRequest): IO[AwsError, model.GetReservationCoverageResponse.ReadOnly]
      def describeCostCategoryDefinition(request: model.DescribeCostCategoryDefinitionRequest): IO[AwsError, model.DescribeCostCategoryDefinitionResponse.ReadOnly]
      def getAnomalyMonitors(request: model.GetAnomalyMonitorsRequest): IO[AwsError, model.GetAnomalyMonitorsResponse.ReadOnly]
      def getTags(request: model.GetTagsRequest): IO[AwsError, model.GetTagsResponse.ReadOnly]
    }
    object CostExplorerMock extends zio.test.mock.Mock[CostExplorer] {
      object UpdateAnomalySubscription extends Effect[model.UpdateAnomalySubscriptionRequest, AwsError, model.UpdateAnomalySubscriptionResponse.ReadOnly]
      object CreateAnomalySubscription extends Effect[model.CreateAnomalySubscriptionRequest, AwsError, model.CreateAnomalySubscriptionResponse.ReadOnly]
      object GetCostAndUsageWithResources extends Effect[model.GetCostAndUsageWithResourcesRequest, AwsError, model.GetCostAndUsageWithResourcesResponse.ReadOnly]
      object UpdateAnomalyMonitor extends Effect[model.UpdateAnomalyMonitorRequest, AwsError, model.UpdateAnomalyMonitorResponse.ReadOnly]
      object DeleteCostCategoryDefinition extends Effect[model.DeleteCostCategoryDefinitionRequest, AwsError, model.DeleteCostCategoryDefinitionResponse.ReadOnly]
      object GetSavingsPlansPurchaseRecommendation extends Effect[model.GetSavingsPlansPurchaseRecommendationRequest, AwsError, model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly]
      object GetSavingsPlansCoverage extends Stream[model.GetSavingsPlansCoverageRequest, AwsError, model.SavingsPlansCoverage.ReadOnly]
      object GetSavingsPlansUtilization extends Effect[model.GetSavingsPlansUtilizationRequest, AwsError, model.GetSavingsPlansUtilizationResponse.ReadOnly]
      object CreateCostCategoryDefinition extends Effect[model.CreateCostCategoryDefinitionRequest, AwsError, model.CreateCostCategoryDefinitionResponse.ReadOnly]
      object CreateAnomalyMonitor extends Effect[model.CreateAnomalyMonitorRequest, AwsError, model.CreateAnomalyMonitorResponse.ReadOnly]
      object GetSavingsPlansUtilizationDetails extends Effect[model.GetSavingsPlansUtilizationDetailsRequest, AwsError, StreamingOutputResult[Any, model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly, model.SavingsPlansUtilizationDetail.ReadOnly]]
      object GetCostCategories extends Effect[model.GetCostCategoriesRequest, AwsError, model.GetCostCategoriesResponse.ReadOnly]
      object GetReservationPurchaseRecommendation extends Effect[model.GetReservationPurchaseRecommendationRequest, AwsError, model.GetReservationPurchaseRecommendationResponse.ReadOnly]
      object GetUsageForecast extends Effect[model.GetUsageForecastRequest, AwsError, model.GetUsageForecastResponse.ReadOnly]
      object GetDimensionValues extends Effect[model.GetDimensionValuesRequest, AwsError, model.GetDimensionValuesResponse.ReadOnly]
      object GetReservationUtilization extends Effect[model.GetReservationUtilizationRequest, AwsError, model.GetReservationUtilizationResponse.ReadOnly]
      object DeleteAnomalyMonitor extends Effect[model.DeleteAnomalyMonitorRequest, AwsError, model.DeleteAnomalyMonitorResponse.ReadOnly]
      object GetCostAndUsage extends Effect[model.GetCostAndUsageRequest, AwsError, model.GetCostAndUsageResponse.ReadOnly]
      object DeleteAnomalySubscription extends Effect[model.DeleteAnomalySubscriptionRequest, AwsError, model.DeleteAnomalySubscriptionResponse.ReadOnly]
      object GetCostForecast extends Effect[model.GetCostForecastRequest, AwsError, model.GetCostForecastResponse.ReadOnly]
      object ListCostCategoryDefinitions extends Stream[model.ListCostCategoryDefinitionsRequest, AwsError, model.CostCategoryReference.ReadOnly]
      object GetAnomalySubscriptions extends Effect[model.GetAnomalySubscriptionsRequest, AwsError, model.GetAnomalySubscriptionsResponse.ReadOnly]
      object GetAnomalies extends Effect[model.GetAnomaliesRequest, AwsError, model.GetAnomaliesResponse.ReadOnly]
      object GetRightsizingRecommendation extends Effect[model.GetRightsizingRecommendationRequest, AwsError, model.GetRightsizingRecommendationResponse.ReadOnly]
      object ProvideAnomalyFeedback extends Effect[model.ProvideAnomalyFeedbackRequest, AwsError, model.ProvideAnomalyFeedbackResponse.ReadOnly]
      object UpdateCostCategoryDefinition extends Effect[model.UpdateCostCategoryDefinitionRequest, AwsError, model.UpdateCostCategoryDefinitionResponse.ReadOnly]
      object GetReservationCoverage extends Effect[model.GetReservationCoverageRequest, AwsError, model.GetReservationCoverageResponse.ReadOnly]
      object DescribeCostCategoryDefinition extends Effect[model.DescribeCostCategoryDefinitionRequest, AwsError, model.DescribeCostCategoryDefinitionResponse.ReadOnly]
      object GetAnomalyMonitors extends Effect[model.GetAnomalyMonitorsRequest, AwsError, model.GetAnomalyMonitorsResponse.ReadOnly]
      object GetTags extends Effect[model.GetTagsRequest, AwsError, model.GetTagsResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], CostExplorer] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new CostExplorer.Service {
            val api: CostExplorerAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): CostExplorer.Service = this
            def updateAnomalySubscription(request: model.UpdateAnomalySubscriptionRequest): IO[AwsError, model.UpdateAnomalySubscriptionResponse.ReadOnly] = proxy(UpdateAnomalySubscription, request)
            def createAnomalySubscription(request: model.CreateAnomalySubscriptionRequest): IO[AwsError, model.CreateAnomalySubscriptionResponse.ReadOnly] = proxy(CreateAnomalySubscription, request)
            def getCostAndUsageWithResources(request: model.GetCostAndUsageWithResourcesRequest): IO[AwsError, model.GetCostAndUsageWithResourcesResponse.ReadOnly] = proxy(GetCostAndUsageWithResources, request)
            def updateAnomalyMonitor(request: model.UpdateAnomalyMonitorRequest): IO[AwsError, model.UpdateAnomalyMonitorResponse.ReadOnly] = proxy(UpdateAnomalyMonitor, request)
            def deleteCostCategoryDefinition(request: model.DeleteCostCategoryDefinitionRequest): IO[AwsError, model.DeleteCostCategoryDefinitionResponse.ReadOnly] = proxy(DeleteCostCategoryDefinition, request)
            def getSavingsPlansPurchaseRecommendation(request: model.GetSavingsPlansPurchaseRecommendationRequest): IO[AwsError, model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly] = proxy(GetSavingsPlansPurchaseRecommendation, request)
            def getSavingsPlansCoverage(request: model.GetSavingsPlansCoverageRequest): ZStream[Any, AwsError, model.SavingsPlansCoverage.ReadOnly] = rts.unsafeRun(proxy(GetSavingsPlansCoverage, request))
            def getSavingsPlansUtilization(request: model.GetSavingsPlansUtilizationRequest): IO[AwsError, model.GetSavingsPlansUtilizationResponse.ReadOnly] = proxy(GetSavingsPlansUtilization, request)
            def createCostCategoryDefinition(request: model.CreateCostCategoryDefinitionRequest): IO[AwsError, model.CreateCostCategoryDefinitionResponse.ReadOnly] = proxy(CreateCostCategoryDefinition, request)
            def createAnomalyMonitor(request: model.CreateAnomalyMonitorRequest): IO[AwsError, model.CreateAnomalyMonitorResponse.ReadOnly] = proxy(CreateAnomalyMonitor, request)
            def getSavingsPlansUtilizationDetails(request: model.GetSavingsPlansUtilizationDetailsRequest): ZIO[Any, AwsError, StreamingOutputResult[Any, model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly, model.SavingsPlansUtilizationDetail.ReadOnly]] = proxy(GetSavingsPlansUtilizationDetails, request)
            def getCostCategories(request: model.GetCostCategoriesRequest): IO[AwsError, model.GetCostCategoriesResponse.ReadOnly] = proxy(GetCostCategories, request)
            def getReservationPurchaseRecommendation(request: model.GetReservationPurchaseRecommendationRequest): IO[AwsError, model.GetReservationPurchaseRecommendationResponse.ReadOnly] = proxy(GetReservationPurchaseRecommendation, request)
            def getUsageForecast(request: model.GetUsageForecastRequest): IO[AwsError, model.GetUsageForecastResponse.ReadOnly] = proxy(GetUsageForecast, request)
            def getDimensionValues(request: model.GetDimensionValuesRequest): IO[AwsError, model.GetDimensionValuesResponse.ReadOnly] = proxy(GetDimensionValues, request)
            def getReservationUtilization(request: model.GetReservationUtilizationRequest): IO[AwsError, model.GetReservationUtilizationResponse.ReadOnly] = proxy(GetReservationUtilization, request)
            def deleteAnomalyMonitor(request: model.DeleteAnomalyMonitorRequest): IO[AwsError, model.DeleteAnomalyMonitorResponse.ReadOnly] = proxy(DeleteAnomalyMonitor, request)
            def getCostAndUsage(request: model.GetCostAndUsageRequest): IO[AwsError, model.GetCostAndUsageResponse.ReadOnly] = proxy(GetCostAndUsage, request)
            def deleteAnomalySubscription(request: model.DeleteAnomalySubscriptionRequest): IO[AwsError, model.DeleteAnomalySubscriptionResponse.ReadOnly] = proxy(DeleteAnomalySubscription, request)
            def getCostForecast(request: model.GetCostForecastRequest): IO[AwsError, model.GetCostForecastResponse.ReadOnly] = proxy(GetCostForecast, request)
            def listCostCategoryDefinitions(request: model.ListCostCategoryDefinitionsRequest): ZStream[Any, AwsError, model.CostCategoryReference.ReadOnly] = rts.unsafeRun(proxy(ListCostCategoryDefinitions, request))
            def getAnomalySubscriptions(request: model.GetAnomalySubscriptionsRequest): IO[AwsError, model.GetAnomalySubscriptionsResponse.ReadOnly] = proxy(GetAnomalySubscriptions, request)
            def getAnomalies(request: model.GetAnomaliesRequest): IO[AwsError, model.GetAnomaliesResponse.ReadOnly] = proxy(GetAnomalies, request)
            def getRightsizingRecommendation(request: model.GetRightsizingRecommendationRequest): IO[AwsError, model.GetRightsizingRecommendationResponse.ReadOnly] = proxy(GetRightsizingRecommendation, request)
            def provideAnomalyFeedback(request: model.ProvideAnomalyFeedbackRequest): IO[AwsError, model.ProvideAnomalyFeedbackResponse.ReadOnly] = proxy(ProvideAnomalyFeedback, request)
            def updateCostCategoryDefinition(request: model.UpdateCostCategoryDefinitionRequest): IO[AwsError, model.UpdateCostCategoryDefinitionResponse.ReadOnly] = proxy(UpdateCostCategoryDefinition, request)
            def getReservationCoverage(request: model.GetReservationCoverageRequest): IO[AwsError, model.GetReservationCoverageResponse.ReadOnly] = proxy(GetReservationCoverage, request)
            def describeCostCategoryDefinition(request: model.DescribeCostCategoryDefinitionRequest): IO[AwsError, model.DescribeCostCategoryDefinitionResponse.ReadOnly] = proxy(DescribeCostCategoryDefinition, request)
            def getAnomalyMonitors(request: model.GetAnomalyMonitorsRequest): IO[AwsError, model.GetAnomalyMonitorsResponse.ReadOnly] = proxy(GetAnomalyMonitors, request)
            def getTags(request: model.GetTagsRequest): IO[AwsError, model.GetTagsResponse.ReadOnly] = proxy(GetTags, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, CostExplorer] = customized(identity)
  def customized(customization: CostExplorerAsyncClientBuilder => CostExplorerAsyncClientBuilder): ZLayer[AwsConfig, Throwable, CostExplorer] = managed(customization).toLayer
  def managed(customization: CostExplorerAsyncClientBuilder => CostExplorerAsyncClientBuilder): ZManaged[AwsConfig, Throwable, CostExplorer.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = CostExplorerAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[CostExplorerAsyncClient, CostExplorerAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[CostExplorerAsyncClient, CostExplorerAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new CostExplorerImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class CostExplorerImpl[R](override val api: CostExplorerAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends CostExplorer.Service with AwsServiceBase[R, CostExplorerImpl] {
    override val serviceName: String = "CostExplorer"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): CostExplorerImpl[R1] = new CostExplorerImpl(api, newAspect, r)
    def updateAnomalySubscription(request: model.UpdateAnomalySubscriptionRequest): IO[AwsError, model.UpdateAnomalySubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest, software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse]("updateAnomalySubscription", api.updateAnomalySubscription)(request.buildAwsValue()).map(model.UpdateAnomalySubscriptionResponse.wrap).provide(r)
    def createAnomalySubscription(request: model.CreateAnomalySubscriptionRequest): IO[AwsError, model.CreateAnomalySubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest, software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse]("createAnomalySubscription", api.createAnomalySubscription)(request.buildAwsValue()).map(model.CreateAnomalySubscriptionResponse.wrap).provide(r)
    def getCostAndUsageWithResources(request: model.GetCostAndUsageWithResourcesRequest): IO[AwsError, model.GetCostAndUsageWithResourcesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest, software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse]("getCostAndUsageWithResources", api.getCostAndUsageWithResources)(request.buildAwsValue()).map(model.GetCostAndUsageWithResourcesResponse.wrap).provide(r)
    def updateAnomalyMonitor(request: model.UpdateAnomalyMonitorRequest): IO[AwsError, model.UpdateAnomalyMonitorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest, software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorResponse]("updateAnomalyMonitor", api.updateAnomalyMonitor)(request.buildAwsValue()).map(model.UpdateAnomalyMonitorResponse.wrap).provide(r)
    def deleteCostCategoryDefinition(request: model.DeleteCostCategoryDefinitionRequest): IO[AwsError, model.DeleteCostCategoryDefinitionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest, software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse]("deleteCostCategoryDefinition", api.deleteCostCategoryDefinition)(request.buildAwsValue()).map(model.DeleteCostCategoryDefinitionResponse.wrap).provide(r)
    def getSavingsPlansPurchaseRecommendation(request: model.GetSavingsPlansPurchaseRecommendationRequest): IO[AwsError, model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest, software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse]("getSavingsPlansPurchaseRecommendation", api.getSavingsPlansPurchaseRecommendation)(request.buildAwsValue()).map(model.GetSavingsPlansPurchaseRecommendationResponse.wrap).provide(r)
    def getSavingsPlansCoverage(request: model.GetSavingsPlansCoverageRequest): ZStream[Any, AwsError, model.SavingsPlansCoverage.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest, software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse, software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage]("getSavingsPlansCoverage", api.getSavingsPlansCoverage, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.savingsPlansCoverages().asScala))(request.buildAwsValue()).map(item => model.SavingsPlansCoverage.wrap(item)).provide(r)
    def getSavingsPlansUtilization(request: model.GetSavingsPlansUtilizationRequest): IO[AwsError, model.GetSavingsPlansUtilizationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest, software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse]("getSavingsPlansUtilization", api.getSavingsPlansUtilization)(request.buildAwsValue()).map(model.GetSavingsPlansUtilizationResponse.wrap).provide(r)
    def createCostCategoryDefinition(request: model.CreateCostCategoryDefinitionRequest): IO[AwsError, model.CreateCostCategoryDefinitionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest, software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse]("createCostCategoryDefinition", api.createCostCategoryDefinition)(request.buildAwsValue()).map(model.CreateCostCategoryDefinitionResponse.wrap).provide(r)
    def createAnomalyMonitor(request: model.CreateAnomalyMonitorRequest): IO[AwsError, model.CreateAnomalyMonitorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest, software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorResponse]("createAnomalyMonitor", api.createAnomalyMonitor)(request.buildAwsValue()).map(model.CreateAnomalyMonitorResponse.wrap).provide(r)
    def getSavingsPlansUtilizationDetails(request: model.GetSavingsPlansUtilizationDetailsRequest): ZIO[Any, AwsError, StreamingOutputResult[Any, model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly, model.SavingsPlansUtilizationDetail.ReadOnly]] = asyncPaginatedRequest[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest, software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse, software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail]("getSavingsPlansUtilizationDetails", api.getSavingsPlansUtilizationDetails, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.savingsPlansUtilizationDetails().asScala))(request.buildAwsValue()).map(result => result.mapResponse(model.GetSavingsPlansUtilizationDetailsResponse.wrap).mapOutput(_.map(item => model.SavingsPlansUtilizationDetail.wrap(item))).provide(r)).provide(r)
    def getCostCategories(request: model.GetCostCategoriesRequest): IO[AwsError, model.GetCostCategoriesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest, software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse]("getCostCategories", api.getCostCategories)(request.buildAwsValue()).map(model.GetCostCategoriesResponse.wrap).provide(r)
    def getReservationPurchaseRecommendation(request: model.GetReservationPurchaseRecommendationRequest): IO[AwsError, model.GetReservationPurchaseRecommendationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest, software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse]("getReservationPurchaseRecommendation", api.getReservationPurchaseRecommendation)(request.buildAwsValue()).map(model.GetReservationPurchaseRecommendationResponse.wrap).provide(r)
    def getUsageForecast(request: model.GetUsageForecastRequest): IO[AwsError, model.GetUsageForecastResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest, software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse]("getUsageForecast", api.getUsageForecast)(request.buildAwsValue()).map(model.GetUsageForecastResponse.wrap).provide(r)
    def getDimensionValues(request: model.GetDimensionValuesRequest): IO[AwsError, model.GetDimensionValuesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest, software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse]("getDimensionValues", api.getDimensionValues)(request.buildAwsValue()).map(model.GetDimensionValuesResponse.wrap).provide(r)
    def getReservationUtilization(request: model.GetReservationUtilizationRequest): IO[AwsError, model.GetReservationUtilizationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest, software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse]("getReservationUtilization", api.getReservationUtilization)(request.buildAwsValue()).map(model.GetReservationUtilizationResponse.wrap).provide(r)
    def deleteAnomalyMonitor(request: model.DeleteAnomalyMonitorRequest): IO[AwsError, model.DeleteAnomalyMonitorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest, software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorResponse]("deleteAnomalyMonitor", api.deleteAnomalyMonitor)(request.buildAwsValue()).map(model.DeleteAnomalyMonitorResponse.wrap).provide(r)
    def getCostAndUsage(request: model.GetCostAndUsageRequest): IO[AwsError, model.GetCostAndUsageResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest, software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse]("getCostAndUsage", api.getCostAndUsage)(request.buildAwsValue()).map(model.GetCostAndUsageResponse.wrap).provide(r)
    def deleteAnomalySubscription(request: model.DeleteAnomalySubscriptionRequest): IO[AwsError, model.DeleteAnomalySubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest, software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionResponse]("deleteAnomalySubscription", api.deleteAnomalySubscription)(request.buildAwsValue()).map(model.DeleteAnomalySubscriptionResponse.wrap).provide(r)
    def getCostForecast(request: model.GetCostForecastRequest): IO[AwsError, model.GetCostForecastResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest, software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse]("getCostForecast", api.getCostForecast)(request.buildAwsValue()).map(model.GetCostForecastResponse.wrap).provide(r)
    def listCostCategoryDefinitions(request: model.ListCostCategoryDefinitionsRequest): ZStream[Any, AwsError, model.CostCategoryReference.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest, software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse, software.amazon.awssdk.services.costexplorer.model.CostCategoryReference]("listCostCategoryDefinitions", api.listCostCategoryDefinitions, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.costCategoryReferences().asScala))(request.buildAwsValue()).map(item => model.CostCategoryReference.wrap(item)).provide(r)
    def getAnomalySubscriptions(request: model.GetAnomalySubscriptionsRequest): IO[AwsError, model.GetAnomalySubscriptionsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest, software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse]("getAnomalySubscriptions", api.getAnomalySubscriptions)(request.buildAwsValue()).map(model.GetAnomalySubscriptionsResponse.wrap).provide(r)
    def getAnomalies(request: model.GetAnomaliesRequest): IO[AwsError, model.GetAnomaliesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest, software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse]("getAnomalies", api.getAnomalies)(request.buildAwsValue()).map(model.GetAnomaliesResponse.wrap).provide(r)
    def getRightsizingRecommendation(request: model.GetRightsizingRecommendationRequest): IO[AwsError, model.GetRightsizingRecommendationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest, software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse]("getRightsizingRecommendation", api.getRightsizingRecommendation)(request.buildAwsValue()).map(model.GetRightsizingRecommendationResponse.wrap).provide(r)
    def provideAnomalyFeedback(request: model.ProvideAnomalyFeedbackRequest): IO[AwsError, model.ProvideAnomalyFeedbackResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest, software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse]("provideAnomalyFeedback", api.provideAnomalyFeedback)(request.buildAwsValue()).map(model.ProvideAnomalyFeedbackResponse.wrap).provide(r)
    def updateCostCategoryDefinition(request: model.UpdateCostCategoryDefinitionRequest): IO[AwsError, model.UpdateCostCategoryDefinitionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest, software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse]("updateCostCategoryDefinition", api.updateCostCategoryDefinition)(request.buildAwsValue()).map(model.UpdateCostCategoryDefinitionResponse.wrap).provide(r)
    def getReservationCoverage(request: model.GetReservationCoverageRequest): IO[AwsError, model.GetReservationCoverageResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest, software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse]("getReservationCoverage", api.getReservationCoverage)(request.buildAwsValue()).map(model.GetReservationCoverageResponse.wrap).provide(r)
    def describeCostCategoryDefinition(request: model.DescribeCostCategoryDefinitionRequest): IO[AwsError, model.DescribeCostCategoryDefinitionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest, software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse]("describeCostCategoryDefinition", api.describeCostCategoryDefinition)(request.buildAwsValue()).map(model.DescribeCostCategoryDefinitionResponse.wrap).provide(r)
    def getAnomalyMonitors(request: model.GetAnomalyMonitorsRequest): IO[AwsError, model.GetAnomalyMonitorsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest, software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse]("getAnomalyMonitors", api.getAnomalyMonitors)(request.buildAwsValue()).map(model.GetAnomalyMonitorsResponse.wrap).provide(r)
    def getTags(request: model.GetTagsRequest): IO[AwsError, model.GetTagsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.costexplorer.model.GetTagsRequest, software.amazon.awssdk.services.costexplorer.model.GetTagsResponse]("getTags", api.getTags)(request.buildAwsValue()).map(model.GetTagsResponse.wrap).provide(r)
  }
  def updateAnomalySubscription(request: model.UpdateAnomalySubscriptionRequest): ZIO[CostExplorer, AwsError, model.UpdateAnomalySubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.updateAnomalySubscription(request))
  def createAnomalySubscription(request: model.CreateAnomalySubscriptionRequest): ZIO[CostExplorer, AwsError, model.CreateAnomalySubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.createAnomalySubscription(request))
  def getCostAndUsageWithResources(request: model.GetCostAndUsageWithResourcesRequest): ZIO[CostExplorer, AwsError, model.GetCostAndUsageWithResourcesResponse.ReadOnly] = ZIO.accessM(_.get.getCostAndUsageWithResources(request))
  def updateAnomalyMonitor(request: model.UpdateAnomalyMonitorRequest): ZIO[CostExplorer, AwsError, model.UpdateAnomalyMonitorResponse.ReadOnly] = ZIO.accessM(_.get.updateAnomalyMonitor(request))
  def deleteCostCategoryDefinition(request: model.DeleteCostCategoryDefinitionRequest): ZIO[CostExplorer, AwsError, model.DeleteCostCategoryDefinitionResponse.ReadOnly] = ZIO.accessM(_.get.deleteCostCategoryDefinition(request))
  def getSavingsPlansPurchaseRecommendation(request: model.GetSavingsPlansPurchaseRecommendationRequest): ZIO[CostExplorer, AwsError, model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly] = ZIO.accessM(_.get.getSavingsPlansPurchaseRecommendation(request))
  def getSavingsPlansCoverage(request: model.GetSavingsPlansCoverageRequest): ZStream[CostExplorer, AwsError, model.SavingsPlansCoverage.ReadOnly] = ZStream.accessStream(_.get.getSavingsPlansCoverage(request))
  def getSavingsPlansUtilization(request: model.GetSavingsPlansUtilizationRequest): ZIO[CostExplorer, AwsError, model.GetSavingsPlansUtilizationResponse.ReadOnly] = ZIO.accessM(_.get.getSavingsPlansUtilization(request))
  def createCostCategoryDefinition(request: model.CreateCostCategoryDefinitionRequest): ZIO[CostExplorer, AwsError, model.CreateCostCategoryDefinitionResponse.ReadOnly] = ZIO.accessM(_.get.createCostCategoryDefinition(request))
  def createAnomalyMonitor(request: model.CreateAnomalyMonitorRequest): ZIO[CostExplorer, AwsError, model.CreateAnomalyMonitorResponse.ReadOnly] = ZIO.accessM(_.get.createAnomalyMonitor(request))
  def getSavingsPlansUtilizationDetails(request: model.GetSavingsPlansUtilizationDetailsRequest): ZIO[CostExplorer, AwsError, StreamingOutputResult[Any, model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly, model.SavingsPlansUtilizationDetail.ReadOnly]] = ZIO.accessM(_.get.getSavingsPlansUtilizationDetails(request))
  def getCostCategories(request: model.GetCostCategoriesRequest): ZIO[CostExplorer, AwsError, model.GetCostCategoriesResponse.ReadOnly] = ZIO.accessM(_.get.getCostCategories(request))
  def getReservationPurchaseRecommendation(request: model.GetReservationPurchaseRecommendationRequest): ZIO[CostExplorer, AwsError, model.GetReservationPurchaseRecommendationResponse.ReadOnly] = ZIO.accessM(_.get.getReservationPurchaseRecommendation(request))
  def getUsageForecast(request: model.GetUsageForecastRequest): ZIO[CostExplorer, AwsError, model.GetUsageForecastResponse.ReadOnly] = ZIO.accessM(_.get.getUsageForecast(request))
  def getDimensionValues(request: model.GetDimensionValuesRequest): ZIO[CostExplorer, AwsError, model.GetDimensionValuesResponse.ReadOnly] = ZIO.accessM(_.get.getDimensionValues(request))
  def getReservationUtilization(request: model.GetReservationUtilizationRequest): ZIO[CostExplorer, AwsError, model.GetReservationUtilizationResponse.ReadOnly] = ZIO.accessM(_.get.getReservationUtilization(request))
  def deleteAnomalyMonitor(request: model.DeleteAnomalyMonitorRequest): ZIO[CostExplorer, AwsError, model.DeleteAnomalyMonitorResponse.ReadOnly] = ZIO.accessM(_.get.deleteAnomalyMonitor(request))
  def getCostAndUsage(request: model.GetCostAndUsageRequest): ZIO[CostExplorer, AwsError, model.GetCostAndUsageResponse.ReadOnly] = ZIO.accessM(_.get.getCostAndUsage(request))
  def deleteAnomalySubscription(request: model.DeleteAnomalySubscriptionRequest): ZIO[CostExplorer, AwsError, model.DeleteAnomalySubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.deleteAnomalySubscription(request))
  def getCostForecast(request: model.GetCostForecastRequest): ZIO[CostExplorer, AwsError, model.GetCostForecastResponse.ReadOnly] = ZIO.accessM(_.get.getCostForecast(request))
  def listCostCategoryDefinitions(request: model.ListCostCategoryDefinitionsRequest): ZStream[CostExplorer, AwsError, model.CostCategoryReference.ReadOnly] = ZStream.accessStream(_.get.listCostCategoryDefinitions(request))
  def getAnomalySubscriptions(request: model.GetAnomalySubscriptionsRequest): ZIO[CostExplorer, AwsError, model.GetAnomalySubscriptionsResponse.ReadOnly] = ZIO.accessM(_.get.getAnomalySubscriptions(request))
  def getAnomalies(request: model.GetAnomaliesRequest): ZIO[CostExplorer, AwsError, model.GetAnomaliesResponse.ReadOnly] = ZIO.accessM(_.get.getAnomalies(request))
  def getRightsizingRecommendation(request: model.GetRightsizingRecommendationRequest): ZIO[CostExplorer, AwsError, model.GetRightsizingRecommendationResponse.ReadOnly] = ZIO.accessM(_.get.getRightsizingRecommendation(request))
  def provideAnomalyFeedback(request: model.ProvideAnomalyFeedbackRequest): ZIO[CostExplorer, AwsError, model.ProvideAnomalyFeedbackResponse.ReadOnly] = ZIO.accessM(_.get.provideAnomalyFeedback(request))
  def updateCostCategoryDefinition(request: model.UpdateCostCategoryDefinitionRequest): ZIO[CostExplorer, AwsError, model.UpdateCostCategoryDefinitionResponse.ReadOnly] = ZIO.accessM(_.get.updateCostCategoryDefinition(request))
  def getReservationCoverage(request: model.GetReservationCoverageRequest): ZIO[CostExplorer, AwsError, model.GetReservationCoverageResponse.ReadOnly] = ZIO.accessM(_.get.getReservationCoverage(request))
  def describeCostCategoryDefinition(request: model.DescribeCostCategoryDefinitionRequest): ZIO[CostExplorer, AwsError, model.DescribeCostCategoryDefinitionResponse.ReadOnly] = ZIO.accessM(_.get.describeCostCategoryDefinition(request))
  def getAnomalyMonitors(request: model.GetAnomalyMonitorsRequest): ZIO[CostExplorer, AwsError, model.GetAnomalyMonitorsResponse.ReadOnly] = ZIO.accessM(_.get.getAnomalyMonitors(request))
  def getTags(request: model.GetTagsRequest): ZIO[CostExplorer, AwsError, model.GetTagsResponse.ReadOnly] = ZIO.accessM(_.get.getTags(request))
}