package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateCostCategoryDefinitionRequest(costCategoryArn: primitives.Arn, ruleVersion: CostCategoryRuleVersion, rules: Iterable[CostCategoryRule], defaultValue: scala.Option[primitives.CostCategoryValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest = {
    import UpdateCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest.builder().costCategoryArn(costCategoryArn: java.lang.String).ruleVersion(ruleVersion.unwrap).rules(rules.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(defaultValue.map(value => value: java.lang.String))(_.defaultValue).build()
  }
  def asReadOnly: UpdateCostCategoryDefinitionRequest.ReadOnly = UpdateCostCategoryDefinitionRequest.wrap(buildAwsValue())
}
object UpdateCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateCostCategoryDefinitionRequest = UpdateCostCategoryDefinitionRequest(costCategoryArnValue, ruleVersionValue, rulesValue.map { item => 
      item.editable
    }, defaultValueValue.map(value => value))
    def costCategoryArnValue: primitives.Arn
    def ruleVersionValue: CostCategoryRuleVersion
    def rulesValue: List[CostCategoryRule.ReadOnly]
    def defaultValueValue: scala.Option[primitives.CostCategoryValue]
    def costCategoryArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(costCategoryArnValue)
    def ruleVersion: ZIO[Any, Nothing, CostCategoryRuleVersion] = ZIO.succeed(ruleVersionValue)
    def rules: ZIO[Any, Nothing, List[CostCategoryRule.ReadOnly]] = ZIO.succeed(rulesValue)
    def defaultValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultValue", defaultValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest) extends UpdateCostCategoryDefinitionRequest.ReadOnly {
    override def costCategoryArnValue: primitives.Arn = impl.costCategoryArn(): primitives.Arn
    override def ruleVersionValue: CostCategoryRuleVersion = CostCategoryRuleVersion.wrap(impl.ruleVersion())
    override def rulesValue: List[CostCategoryRule.ReadOnly] = impl.rules().asScala.map { item => 
      CostCategoryRule.wrap(item)
    }.toList
    override def defaultValueValue: scala.Option[primitives.CostCategoryValue] = scala.Option(impl.defaultValue()).map(value => value: primitives.CostCategoryValue)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest): ReadOnly = new Wrapper(impl)
}