package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TotalImpactFilter(numericOperator: NumericOperator, startValue: primitives.GenericDouble, endValue: scala.Option[primitives.GenericDouble] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter = {
    import TotalImpactFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter.builder().numericOperator(numericOperator.unwrap).startValue(startValue: java.lang.Double).optionallyWith(endValue.map(value => value: java.lang.Double))(_.endValue).build()
  }
  def asReadOnly: TotalImpactFilter.ReadOnly = TotalImpactFilter.wrap(buildAwsValue())
}
object TotalImpactFilter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TotalImpactFilter = TotalImpactFilter(numericOperatorValue, startValueValue, endValueValue.map(value => value))
    def numericOperatorValue: NumericOperator
    def startValueValue: primitives.GenericDouble
    def endValueValue: scala.Option[primitives.GenericDouble]
    def numericOperator: ZIO[Any, Nothing, NumericOperator] = ZIO.succeed(numericOperatorValue)
    def startValue: ZIO[Any, Nothing, primitives.GenericDouble] = ZIO.succeed(startValueValue)
    def endValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericDouble] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endValue", endValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter) extends TotalImpactFilter.ReadOnly {
    override def numericOperatorValue: NumericOperator = NumericOperator.wrap(impl.numericOperator())
    override def startValueValue: primitives.GenericDouble = impl.startValue(): primitives.GenericDouble
    override def endValueValue: scala.Option[primitives.GenericDouble] = scala.Option(impl.endValue()).map(value => value: primitives.GenericDouble)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter): ReadOnly = new Wrapper(impl)
}