package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansCoverage(attributes: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = None, coverage: scala.Option[SavingsPlansCoverageData] = None, timePeriod: scala.Option[DateInterval] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage = {
    import SavingsPlansCoverage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage.builder().optionallyWith(attributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.attributes).optionallyWith(coverage.map(value => value.buildAwsValue()))(_.coverage).optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).build()
  }
  def asReadOnly: SavingsPlansCoverage.ReadOnly = SavingsPlansCoverage.wrap(buildAwsValue())
}
object SavingsPlansCoverage {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansCoverage = SavingsPlansCoverage(attributesValue.map(value => value), coverageValue.map(value => value.editable), timePeriodValue.map(value => value.editable))
    def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]]
    def coverageValue: scala.Option[SavingsPlansCoverageData.ReadOnly]
    def timePeriodValue: scala.Option[DateInterval.ReadOnly]
    def attributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.AttributeType, primitives.AttributeValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributes", attributesValue)
    def coverage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansCoverageData.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("coverage", coverageValue)
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DateInterval.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage) extends SavingsPlansCoverage.ReadOnly {
    override def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = scala.Option(impl.attributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.AttributeType) -> (value: primitives.AttributeValue)
    }).toMap)
    override def coverageValue: scala.Option[SavingsPlansCoverageData.ReadOnly] = scala.Option(impl.coverage()).map(value => SavingsPlansCoverageData.wrap(value))
    override def timePeriodValue: scala.Option[DateInterval.ReadOnly] = scala.Option(impl.timePeriod()).map(value => DateInterval.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage): ReadOnly = new Wrapper(impl)
}