package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationUtilizationGroup(key: scala.Option[primitives.ReservationGroupKey] = None, value: scala.Option[primitives.ReservationGroupValue] = None, attributes: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = None, utilization: scala.Option[ReservationAggregates] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup = {
    import ReservationUtilizationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup.builder().optionallyWith(key.map(value => value: java.lang.String))(_.key).optionallyWith(value.map(value => value: java.lang.String))(_.value).optionallyWith(attributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.attributes).optionallyWith(utilization.map(value => value.buildAwsValue()))(_.utilization).build()
  }
  def asReadOnly: ReservationUtilizationGroup.ReadOnly = ReservationUtilizationGroup.wrap(buildAwsValue())
}
object ReservationUtilizationGroup {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationUtilizationGroup = ReservationUtilizationGroup(keyValue.map(value => value), valueValue.map(value => value), attributesValue.map(value => value), utilizationValue.map(value => value.editable))
    def keyValue: scala.Option[primitives.ReservationGroupKey]
    def valueValue: scala.Option[primitives.ReservationGroupValue]
    def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]]
    def utilizationValue: scala.Option[ReservationAggregates.ReadOnly]
    def key: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ReservationGroupKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("key", keyValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ReservationGroupValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    def attributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.AttributeType, primitives.AttributeValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributes", attributesValue)
    def utilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReservationAggregates.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("utilization", utilizationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup) extends ReservationUtilizationGroup.ReadOnly {
    override def keyValue: scala.Option[primitives.ReservationGroupKey] = scala.Option(impl.key()).map(value => value: primitives.ReservationGroupKey)
    override def valueValue: scala.Option[primitives.ReservationGroupValue] = scala.Option(impl.value()).map(value => value: primitives.ReservationGroupValue)
    override def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = scala.Option(impl.attributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.AttributeType) -> (value: primitives.AttributeValue)
    }).toMap)
    override def utilizationValue: scala.Option[ReservationAggregates.ReadOnly] = scala.Option(impl.utilization()).map(value => ReservationAggregates.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup): ReadOnly = new Wrapper(impl)
}