package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetReservationUtilizationRequest(timePeriod: DateInterval, groupBy: scala.Option[Iterable[GroupDefinition]] = None, granularity: scala.Option[Granularity] = None, filter: scala.Option[Expression] = None, sortBy: scala.Option[SortDefinition] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest = {
    import GetReservationUtilizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest.builder().timePeriod(timePeriod.buildAwsValue()).optionallyWith(groupBy.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groupBy).optionallyWith(granularity.map(value => value.unwrap))(_.granularity).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: GetReservationUtilizationRequest.ReadOnly = GetReservationUtilizationRequest.wrap(buildAwsValue())
}
object GetReservationUtilizationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetReservationUtilizationRequest = GetReservationUtilizationRequest(timePeriodValue.editable, groupByValue.map(value => value.map { item => 
      item.editable
    }), granularityValue.map(value => value), filterValue.map(value => value.editable), sortByValue.map(value => value.editable), nextPageTokenValue.map(value => value), maxResultsValue.map(value => value))
    def timePeriodValue: DateInterval.ReadOnly
    def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]]
    def granularityValue: scala.Option[Granularity]
    def filterValue: scala.Option[Expression.ReadOnly]
    def sortByValue: scala.Option[SortDefinition.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def groupBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GroupDefinition.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groupBy", groupByValue)
    def granularity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Granularity] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("granularity", granularityValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def sortBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SortDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sortBy", sortByValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest) extends GetReservationUtilizationRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]] = scala.Option(impl.groupBy()).map(value => value.asScala.map { item => 
      GroupDefinition.wrap(item)
    }.toList)
    override def granularityValue: scala.Option[Granularity] = scala.Option(impl.granularity()).map(value => Granularity.wrap(value))
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def sortByValue: scala.Option[SortDefinition.ReadOnly] = scala.Option(impl.sortBy()).map(value => SortDefinition.wrap(value))
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest): ReadOnly = new Wrapper(impl)
}