package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateCostCategoryDefinitionRequest(name: primitives.CostCategoryName, ruleVersion: CostCategoryRuleVersion, rules: Iterable[CostCategoryRule], defaultValue: scala.Option[primitives.CostCategoryValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest = {
    import CreateCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest.builder().name(name: java.lang.String).ruleVersion(ruleVersion.unwrap).rules(rules.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(defaultValue.map(value => value: java.lang.String))(_.defaultValue).build()
  }
  def asReadOnly: CreateCostCategoryDefinitionRequest.ReadOnly = CreateCostCategoryDefinitionRequest.wrap(buildAwsValue())
}
object CreateCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateCostCategoryDefinitionRequest = CreateCostCategoryDefinitionRequest(nameValue, ruleVersionValue, rulesValue.map { item => 
      item.editable
    }, defaultValueValue.map(value => value))
    def nameValue: primitives.CostCategoryName
    def ruleVersionValue: CostCategoryRuleVersion
    def rulesValue: List[CostCategoryRule.ReadOnly]
    def defaultValueValue: scala.Option[primitives.CostCategoryValue]
    def name: ZIO[Any, Nothing, primitives.CostCategoryName] = ZIO.succeed(nameValue)
    def ruleVersion: ZIO[Any, Nothing, CostCategoryRuleVersion] = ZIO.succeed(ruleVersionValue)
    def rules: ZIO[Any, Nothing, List[CostCategoryRule.ReadOnly]] = ZIO.succeed(rulesValue)
    def defaultValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultValue", defaultValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest) extends CreateCostCategoryDefinitionRequest.ReadOnly {
    override def nameValue: primitives.CostCategoryName = impl.name(): primitives.CostCategoryName
    override def ruleVersionValue: CostCategoryRuleVersion = CostCategoryRuleVersion.wrap(impl.ruleVersion())
    override def rulesValue: List[CostCategoryRule.ReadOnly] = impl.rules().asScala.map { item => 
      CostCategoryRule.wrap(item)
    }.toList
    override def defaultValueValue: scala.Option[primitives.CostCategoryValue] = scala.Option(impl.defaultValue()).map(value => value: primitives.CostCategoryValue)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest): ReadOnly = new Wrapper(impl)
}