package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CoverageHours(onDemandHours: scala.Option[primitives.OnDemandHours] = None, reservedHours: scala.Option[primitives.ReservedHours] = None, totalRunningHours: scala.Option[primitives.TotalRunningHours] = None, coverageHoursPercentage: scala.Option[primitives.CoverageHoursPercentage] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CoverageHours = {
    import CoverageHours.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CoverageHours.builder().optionallyWith(onDemandHours.map(value => value: java.lang.String))(_.onDemandHours).optionallyWith(reservedHours.map(value => value: java.lang.String))(_.reservedHours).optionallyWith(totalRunningHours.map(value => value: java.lang.String))(_.totalRunningHours).optionallyWith(coverageHoursPercentage.map(value => value: java.lang.String))(_.coverageHoursPercentage).build()
  }
  def asReadOnly: CoverageHours.ReadOnly = CoverageHours.wrap(buildAwsValue())
}
object CoverageHours {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CoverageHours] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CoverageHours = CoverageHours(onDemandHoursValue.map(value => value), reservedHoursValue.map(value => value), totalRunningHoursValue.map(value => value), coverageHoursPercentageValue.map(value => value))
    def onDemandHoursValue: scala.Option[primitives.OnDemandHours]
    def reservedHoursValue: scala.Option[primitives.ReservedHours]
    def totalRunningHoursValue: scala.Option[primitives.TotalRunningHours]
    def coverageHoursPercentageValue: scala.Option[primitives.CoverageHoursPercentage]
    def onDemandHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OnDemandHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("onDemandHours", onDemandHoursValue)
    def reservedHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ReservedHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservedHours", reservedHoursValue)
    def totalRunningHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TotalRunningHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalRunningHours", totalRunningHoursValue)
    def coverageHoursPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CoverageHoursPercentage] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("coverageHoursPercentage", coverageHoursPercentageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CoverageHours) extends CoverageHours.ReadOnly {
    override def onDemandHoursValue: scala.Option[primitives.OnDemandHours] = scala.Option(impl.onDemandHours()).map(value => value: primitives.OnDemandHours)
    override def reservedHoursValue: scala.Option[primitives.ReservedHours] = scala.Option(impl.reservedHours()).map(value => value: primitives.ReservedHours)
    override def totalRunningHoursValue: scala.Option[primitives.TotalRunningHours] = scala.Option(impl.totalRunningHours()).map(value => value: primitives.TotalRunningHours)
    override def coverageHoursPercentageValue: scala.Option[primitives.CoverageHoursPercentage] = scala.Option(impl.coverageHoursPercentage()).map(value => value: primitives.CoverageHoursPercentage)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CoverageHours): ReadOnly = new Wrapper(impl)
}