package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CostCategoryStatusComponent { def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent }
object CostCategoryStatusComponent {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent): CostCategoryStatusComponent = value match {
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent.COST_EXPLORER =>
      val r = COST_EXPLORER
      r
  }
  case object unknownToSdkVersion extends CostCategoryStatusComponent { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent = software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent.UNKNOWN_TO_SDK_VERSION }
  case object COST_EXPLORER extends CostCategoryStatusComponent { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent = software.amazon.awssdk.services.costexplorer.model.CostCategoryStatusComponent.COST_EXPLORER }
}