package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Anomaly(anomalyId: primitives.GenericString, anomalyStartDate: scala.Option[primitives.YearMonthDay] = None, anomalyEndDate: scala.Option[primitives.YearMonthDay] = None, dimensionValue: scala.Option[primitives.GenericString] = None, rootCauses: scala.Option[Iterable[RootCause]] = None, anomalyScore: AnomalyScore, impact: Impact, monitorArn: primitives.GenericString, feedback: scala.Option[AnomalyFeedbackType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.Anomaly = {
    import Anomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Anomaly.builder().anomalyId(anomalyId: java.lang.String).optionallyWith(anomalyStartDate.map(value => value: java.lang.String))(_.anomalyStartDate).optionallyWith(anomalyEndDate.map(value => value: java.lang.String))(_.anomalyEndDate).optionallyWith(dimensionValue.map(value => value: java.lang.String))(_.dimensionValue).optionallyWith(rootCauses.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.rootCauses).anomalyScore(anomalyScore.buildAwsValue()).impact(impact.buildAwsValue()).monitorArn(monitorArn: java.lang.String).optionallyWith(feedback.map(value => value.unwrap))(_.feedback).build()
  }
  def asReadOnly: Anomaly.ReadOnly = Anomaly.wrap(buildAwsValue())
}
object Anomaly {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.Anomaly] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Anomaly = Anomaly(anomalyIdValue, anomalyStartDateValue.map(value => value), anomalyEndDateValue.map(value => value), dimensionValueValue.map(value => value), rootCausesValue.map(value => value.map { item => 
      item.editable
    }), anomalyScoreValue.editable, impactValue.editable, monitorArnValue, feedbackValue.map(value => value))
    def anomalyIdValue: primitives.GenericString
    def anomalyStartDateValue: scala.Option[primitives.YearMonthDay]
    def anomalyEndDateValue: scala.Option[primitives.YearMonthDay]
    def dimensionValueValue: scala.Option[primitives.GenericString]
    def rootCausesValue: scala.Option[List[RootCause.ReadOnly]]
    def anomalyScoreValue: AnomalyScore.ReadOnly
    def impactValue: Impact.ReadOnly
    def monitorArnValue: primitives.GenericString
    def feedbackValue: scala.Option[AnomalyFeedbackType]
    def anomalyId: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(anomalyIdValue)
    def anomalyStartDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.YearMonthDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("anomalyStartDate", anomalyStartDateValue)
    def anomalyEndDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.YearMonthDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("anomalyEndDate", anomalyEndDateValue)
    def dimensionValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dimensionValue", dimensionValueValue)
    def rootCauses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RootCause.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rootCauses", rootCausesValue)
    def anomalyScore: ZIO[Any, Nothing, AnomalyScore.ReadOnly] = ZIO.succeed(anomalyScoreValue)
    def impact: ZIO[Any, Nothing, Impact.ReadOnly] = ZIO.succeed(impactValue)
    def monitorArn: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(monitorArnValue)
    def feedback: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AnomalyFeedbackType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("feedback", feedbackValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.Anomaly) extends Anomaly.ReadOnly {
    override def anomalyIdValue: primitives.GenericString = impl.anomalyId(): primitives.GenericString
    override def anomalyStartDateValue: scala.Option[primitives.YearMonthDay] = scala.Option(impl.anomalyStartDate()).map(value => value: primitives.YearMonthDay)
    override def anomalyEndDateValue: scala.Option[primitives.YearMonthDay] = scala.Option(impl.anomalyEndDate()).map(value => value: primitives.YearMonthDay)
    override def dimensionValueValue: scala.Option[primitives.GenericString] = scala.Option(impl.dimensionValue()).map(value => value: primitives.GenericString)
    override def rootCausesValue: scala.Option[List[RootCause.ReadOnly]] = scala.Option(impl.rootCauses()).map(value => value.asScala.map { item => 
      RootCause.wrap(item)
    }.toList)
    override def anomalyScoreValue: AnomalyScore.ReadOnly = AnomalyScore.wrap(impl.anomalyScore())
    override def impactValue: Impact.ReadOnly = Impact.wrap(impl.impact())
    override def monitorArnValue: primitives.GenericString = impl.monitorArn(): primitives.GenericString
    override def feedbackValue: scala.Option[AnomalyFeedbackType] = scala.Option(impl.feedback()).map(value => AnomalyFeedbackType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.Anomaly): ReadOnly = new Wrapper(impl)
}