package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait TermInYears { def unwrap: software.amazon.awssdk.services.costexplorer.model.TermInYears }
object TermInYears {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.TermInYears): TermInYears = value match {
    case software.amazon.awssdk.services.costexplorer.model.TermInYears.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.TermInYears.ONE_YEAR =>
      val r = ONE_YEAR
      r
    case software.amazon.awssdk.services.costexplorer.model.TermInYears.THREE_YEARS =>
      val r = THREE_YEARS
      r
  }
  case object unknownToSdkVersion extends TermInYears { override def unwrap: software.amazon.awssdk.services.costexplorer.model.TermInYears = software.amazon.awssdk.services.costexplorer.model.TermInYears.UNKNOWN_TO_SDK_VERSION }
  case object ONE_YEAR extends TermInYears { override def unwrap: software.amazon.awssdk.services.costexplorer.model.TermInYears = software.amazon.awssdk.services.costexplorer.model.TermInYears.ONE_YEAR }
  case object THREE_YEARS extends TermInYears { override def unwrap: software.amazon.awssdk.services.costexplorer.model.TermInYears = software.amazon.awssdk.services.costexplorer.model.TermInYears.THREE_YEARS }
}