package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EC2Specification(offeringClass: scala.Option[OfferingClass] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.EC2Specification = {
    import EC2Specification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2Specification.builder().optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass).build()
  }
  def asReadOnly: EC2Specification.ReadOnly = EC2Specification.wrap(buildAwsValue())
}
object EC2Specification {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.EC2Specification] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EC2Specification = EC2Specification(offeringClassValue.map(value => value))
    def offeringClassValue: scala.Option[OfferingClass]
    def offeringClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OfferingClass] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringClass", offeringClassValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.EC2Specification) extends EC2Specification.ReadOnly { override def offeringClassValue: scala.Option[OfferingClass] = scala.Option(impl.offeringClass()).map(value => OfferingClass.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.EC2Specification): ReadOnly = new Wrapper(impl)
}