package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RDSInstanceDetails(family: scala.Option[primitives.GenericString] = None, instanceType: scala.Option[primitives.GenericString] = None, region: scala.Option[primitives.GenericString] = None, databaseEngine: scala.Option[primitives.GenericString] = None, databaseEdition: scala.Option[primitives.GenericString] = None, deploymentOption: scala.Option[primitives.GenericString] = None, licenseModel: scala.Option[primitives.GenericString] = None, currentGeneration: scala.Option[primitives.GenericBoolean] = None, sizeFlexEligible: scala.Option[primitives.GenericBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails = {
    import RDSInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails.builder().optionallyWith(family.map(value => value: java.lang.String))(_.family).optionallyWith(instanceType.map(value => value: java.lang.String))(_.instanceType).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(databaseEngine.map(value => value: java.lang.String))(_.databaseEngine).optionallyWith(databaseEdition.map(value => value: java.lang.String))(_.databaseEdition).optionallyWith(deploymentOption.map(value => value: java.lang.String))(_.deploymentOption).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(_.currentGeneration).optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(_.sizeFlexEligible).build()
  }
  def asReadOnly: RDSInstanceDetails.ReadOnly = RDSInstanceDetails.wrap(buildAwsValue())
}
object RDSInstanceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RDSInstanceDetails = RDSInstanceDetails(familyValue.map(value => value), instanceTypeValue.map(value => value), regionValue.map(value => value), databaseEngineValue.map(value => value), databaseEditionValue.map(value => value), deploymentOptionValue.map(value => value), licenseModelValue.map(value => value), currentGenerationValue.map(value => value), sizeFlexEligibleValue.map(value => value))
    def familyValue: scala.Option[primitives.GenericString]
    def instanceTypeValue: scala.Option[primitives.GenericString]
    def regionValue: scala.Option[primitives.GenericString]
    def databaseEngineValue: scala.Option[primitives.GenericString]
    def databaseEditionValue: scala.Option[primitives.GenericString]
    def deploymentOptionValue: scala.Option[primitives.GenericString]
    def licenseModelValue: scala.Option[primitives.GenericString]
    def currentGenerationValue: scala.Option[primitives.GenericBoolean]
    def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean]
    def family: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("family", familyValue)
    def instanceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def databaseEngine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseEngine", databaseEngineValue)
    def databaseEdition: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseEdition", databaseEditionValue)
    def deploymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deploymentOption", deploymentOptionValue)
    def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
    def currentGeneration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails) extends RDSInstanceDetails.ReadOnly {
    override def familyValue: scala.Option[primitives.GenericString] = scala.Option(impl.family()).map(value => value: primitives.GenericString)
    override def instanceTypeValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceType()).map(value => value: primitives.GenericString)
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def databaseEngineValue: scala.Option[primitives.GenericString] = scala.Option(impl.databaseEngine()).map(value => value: primitives.GenericString)
    override def databaseEditionValue: scala.Option[primitives.GenericString] = scala.Option(impl.databaseEdition()).map(value => value: primitives.GenericString)
    override def deploymentOptionValue: scala.Option[primitives.GenericString] = scala.Option(impl.deploymentOption()).map(value => value: primitives.GenericString)
    override def licenseModelValue: scala.Option[primitives.GenericString] = scala.Option(impl.licenseModel()).map(value => value: primitives.GenericString)
    override def currentGenerationValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.currentGeneration()).map(value => value: primitives.GenericBoolean)
    override def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.sizeFlexEligible()).map(value => value: primitives.GenericBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails): ReadOnly = new Wrapper(impl)
}