package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetTagsResponse(nextPageToken: scala.Option[primitives.NextPageToken] = None, tags: Iterable[primitives.Entity], returnSize: primitives.PageSize, totalSize: primitives.PageSize) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetTagsResponse = {
    import GetTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetTagsResponse.builder().optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).tags(tags.map { item => 
      item: java.lang.String
    }.asJavaCollection).returnSize(returnSize: java.lang.Integer).totalSize(totalSize: java.lang.Integer).build()
  }
  def asReadOnly: GetTagsResponse.ReadOnly = GetTagsResponse.wrap(buildAwsValue())
}
object GetTagsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetTagsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetTagsResponse = GetTagsResponse(nextPageTokenValue.map(value => value), tagsValue, returnSizeValue, totalSizeValue)
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def tagsValue: List[primitives.Entity]
    def returnSizeValue: primitives.PageSize
    def totalSizeValue: primitives.PageSize
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def tags: ZIO[Any, Nothing, List[primitives.Entity]] = ZIO.succeed(tagsValue)
    def returnSize: ZIO[Any, Nothing, primitives.PageSize] = ZIO.succeed(returnSizeValue)
    def totalSize: ZIO[Any, Nothing, primitives.PageSize] = ZIO.succeed(totalSizeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetTagsResponse) extends GetTagsResponse.ReadOnly {
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def tagsValue: List[primitives.Entity] = impl.tags().asScala.map { item => 
      item: primitives.Entity
    }.toList
    override def returnSizeValue: primitives.PageSize = impl.returnSize(): primitives.PageSize
    override def totalSizeValue: primitives.PageSize = impl.totalSize(): primitives.PageSize
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetTagsResponse): ReadOnly = new Wrapper(impl)
}