package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AnomalyDateInterval(startDate: primitives.YearMonthDay, endDate: scala.Option[primitives.YearMonthDay] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval = {
    import AnomalyDateInterval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval.builder().startDate(startDate: java.lang.String).optionallyWith(endDate.map(value => value: java.lang.String))(_.endDate).build()
  }
  def asReadOnly: AnomalyDateInterval.ReadOnly = AnomalyDateInterval.wrap(buildAwsValue())
}
object AnomalyDateInterval {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AnomalyDateInterval = AnomalyDateInterval(startDateValue, endDateValue.map(value => value))
    def startDateValue: primitives.YearMonthDay
    def endDateValue: scala.Option[primitives.YearMonthDay]
    def startDate: ZIO[Any, Nothing, primitives.YearMonthDay] = ZIO.succeed(startDateValue)
    def endDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.YearMonthDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endDate", endDateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval) extends AnomalyDateInterval.ReadOnly {
    override def startDateValue: primitives.YearMonthDay = impl.startDate(): primitives.YearMonthDay
    override def endDateValue: scala.Option[primitives.YearMonthDay] = scala.Option(impl.endDate()).map(value => value: primitives.YearMonthDay)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval): ReadOnly = new Wrapper(impl)
}