package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansUtilizationByTime(timePeriod: DateInterval, utilization: SavingsPlansUtilization, savings: scala.Option[SavingsPlansSavings] = None, amortizedCommitment: scala.Option[SavingsPlansAmortizedCommitment] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime = {
    import SavingsPlansUtilizationByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime.builder().timePeriod(timePeriod.buildAwsValue()).utilization(utilization.buildAwsValue()).optionallyWith(savings.map(value => value.buildAwsValue()))(_.savings).optionallyWith(amortizedCommitment.map(value => value.buildAwsValue()))(_.amortizedCommitment).build()
  }
  def asReadOnly: SavingsPlansUtilizationByTime.ReadOnly = SavingsPlansUtilizationByTime.wrap(buildAwsValue())
}
object SavingsPlansUtilizationByTime {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansUtilizationByTime = SavingsPlansUtilizationByTime(timePeriodValue.editable, utilizationValue.editable, savingsValue.map(value => value.editable), amortizedCommitmentValue.map(value => value.editable))
    def timePeriodValue: DateInterval.ReadOnly
    def utilizationValue: SavingsPlansUtilization.ReadOnly
    def savingsValue: scala.Option[SavingsPlansSavings.ReadOnly]
    def amortizedCommitmentValue: scala.Option[SavingsPlansAmortizedCommitment.ReadOnly]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def utilization: ZIO[Any, Nothing, SavingsPlansUtilization.ReadOnly] = ZIO.succeed(utilizationValue)
    def savings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansSavings.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savings", savingsValue)
    def amortizedCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansAmortizedCommitment.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amortizedCommitment", amortizedCommitmentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime) extends SavingsPlansUtilizationByTime.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def utilizationValue: SavingsPlansUtilization.ReadOnly = SavingsPlansUtilization.wrap(impl.utilization())
    override def savingsValue: scala.Option[SavingsPlansSavings.ReadOnly] = scala.Option(impl.savings()).map(value => SavingsPlansSavings.wrap(value))
    override def amortizedCommitmentValue: scala.Option[SavingsPlansAmortizedCommitment.ReadOnly] = scala.Option(impl.amortizedCommitment()).map(value => SavingsPlansAmortizedCommitment.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime): ReadOnly = new Wrapper(impl)
}