package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansDetails(region: scala.Option[primitives.GenericString] = None, instanceFamily: scala.Option[primitives.GenericString] = None, offeringId: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails = {
    import SavingsPlansDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails.builder().optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(instanceFamily.map(value => value: java.lang.String))(_.instanceFamily).optionallyWith(offeringId.map(value => value: java.lang.String))(_.offeringId).build()
  }
  def asReadOnly: SavingsPlansDetails.ReadOnly = SavingsPlansDetails.wrap(buildAwsValue())
}
object SavingsPlansDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansDetails = SavingsPlansDetails(regionValue.map(value => value), instanceFamilyValue.map(value => value), offeringIdValue.map(value => value))
    def regionValue: scala.Option[primitives.GenericString]
    def instanceFamilyValue: scala.Option[primitives.GenericString]
    def offeringIdValue: scala.Option[primitives.GenericString]
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def instanceFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceFamily", instanceFamilyValue)
    def offeringId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringId", offeringIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails) extends SavingsPlansDetails.ReadOnly {
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def instanceFamilyValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceFamily()).map(value => value: primitives.GenericString)
    override def offeringIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.offeringId()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails): ReadOnly = new Wrapper(impl)
}