package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RootCause(service: scala.Option[primitives.GenericString] = None, region: scala.Option[primitives.GenericString] = None, linkedAccount: scala.Option[primitives.GenericString] = None, usageType: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RootCause = {
    import RootCause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RootCause.builder().optionallyWith(service.map(value => value: java.lang.String))(_.service).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(linkedAccount.map(value => value: java.lang.String))(_.linkedAccount).optionallyWith(usageType.map(value => value: java.lang.String))(_.usageType).build()
  }
  def asReadOnly: RootCause.ReadOnly = RootCause.wrap(buildAwsValue())
}
object RootCause {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RootCause] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RootCause = RootCause(serviceValue.map(value => value), regionValue.map(value => value), linkedAccountValue.map(value => value), usageTypeValue.map(value => value))
    def serviceValue: scala.Option[primitives.GenericString]
    def regionValue: scala.Option[primitives.GenericString]
    def linkedAccountValue: scala.Option[primitives.GenericString]
    def usageTypeValue: scala.Option[primitives.GenericString]
    def service: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("service", serviceValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def linkedAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("linkedAccount", linkedAccountValue)
    def usageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usageType", usageTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RootCause) extends RootCause.ReadOnly {
    override def serviceValue: scala.Option[primitives.GenericString] = scala.Option(impl.service()).map(value => value: primitives.GenericString)
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def linkedAccountValue: scala.Option[primitives.GenericString] = scala.Option(impl.linkedAccount()).map(value => value: primitives.GenericString)
    override def usageTypeValue: scala.Option[primitives.GenericString] = scala.Option(impl.usageType()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RootCause): ReadOnly = new Wrapper(impl)
}