package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategoryValues(key: scala.Option[primitives.CostCategoryName] = None, values: scala.Option[Iterable[primitives.Value]] = None, matchOptions: scala.Option[Iterable[MatchOption]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategoryValues = {
    import CostCategoryValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryValues.builder().optionallyWith(key.map(value => value: java.lang.String))(_.key).optionallyWith(values.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.values).optionallyWith(matchOptions.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.matchOptionsWithStrings).build()
  }
  def asReadOnly: CostCategoryValues.ReadOnly = CostCategoryValues.wrap(buildAwsValue())
}
object CostCategoryValues {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategoryValues] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategoryValues = CostCategoryValues(keyValue.map(value => value), valuesValue.map(value => value), matchOptionsValue.map(value => value))
    def keyValue: scala.Option[primitives.CostCategoryName]
    def valuesValue: scala.Option[List[primitives.Value]]
    def matchOptionsValue: scala.Option[List[MatchOption]]
    def key: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("key", keyValue)
    def values: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Value]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("values", valuesValue)
    def matchOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[MatchOption]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("matchOptions", matchOptionsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryValues) extends CostCategoryValues.ReadOnly {
    override def keyValue: scala.Option[primitives.CostCategoryName] = scala.Option(impl.key()).map(value => value: primitives.CostCategoryName)
    override def valuesValue: scala.Option[List[primitives.Value]] = scala.Option(impl.values()).map(value => value.asScala.map { item => 
      item: primitives.Value
    }.toList)
    override def matchOptionsValue: scala.Option[List[MatchOption]] = scala.Option(impl.matchOptions()).map(value => value.asScala.map { item => 
      MatchOption.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryValues): ReadOnly = new Wrapper(impl)
}