package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CostCategoryRuleType { def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType }
object CostCategoryRuleType {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType): CostCategoryRuleType = value match {
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.REGULAR =>
      val r = REGULAR
      r
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.INHERITED_VALUE =>
      val r = INHERITED_VALUE
      r
  }
  case object unknownToSdkVersion extends CostCategoryRuleType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType = software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.UNKNOWN_TO_SDK_VERSION }
  case object REGULAR extends CostCategoryRuleType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType = software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.REGULAR }
  case object INHERITED_VALUE extends CostCategoryRuleType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType = software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.INHERITED_VALUE }
}