package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class UpdateBudgetRequest(
    accountId: AccountId,
    newBudget: io.github.vigoo.zioaws.budgets.model.Budget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest = {
    import UpdateBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .newBudget(newBudget.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.UpdateBudgetRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.UpdateBudgetRequest
      .wrap(buildAwsValue())
}
object UpdateBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.UpdateBudgetRequest =
      io.github.vigoo.zioaws.budgets.model
        .UpdateBudgetRequest(accountIdValue, newBudgetValue.editable)
    def accountIdValue: AccountId
    def newBudgetValue: io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def newBudget: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    ] = ZIO.succeed(newBudgetValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest
  ) extends io.github.vigoo.zioaws.budgets.model.UpdateBudgetRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def newBudgetValue
        : io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Budget.wrap(impl.newBudget())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest
  ): io.github.vigoo.zioaws.budgets.model.UpdateBudgetRequest.ReadOnly =
    new Wrapper(impl)
}
