package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  RoleArn,
  ActionId,
  BudgetName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class UpdateBudgetActionRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    actionId: ActionId,
    notificationType: Option[
      io.github.vigoo.zioaws.budgets.model.NotificationType
    ] = None,
    actionThreshold: Option[
      io.github.vigoo.zioaws.budgets.model.ActionThreshold
    ] = None,
    definition: Option[io.github.vigoo.zioaws.budgets.model.Definition] = None,
    executionRoleArn: Option[RoleArn] = None,
    approvalModel: Option[io.github.vigoo.zioaws.budgets.model.ApprovalModel] =
      None,
    subscribers: Option[
      Iterable[io.github.vigoo.zioaws.budgets.model.Subscriber]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest = {
    import UpdateBudgetActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .actionId(actionId: java.lang.String)
      .optionallyWith(notificationType.map(value => value.unwrap))(
        _.notificationType
      )
      .optionallyWith(actionThreshold.map(value => value.buildAwsValue()))(
        _.actionThreshold
      )
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(approvalModel.map(value => value.unwrap))(_.approvalModel)
      .optionallyWith(
        subscribers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscribers)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionRequest
      .wrap(buildAwsValue())
}
object UpdateBudgetActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionRequest =
      io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionRequest(
        accountIdValue,
        budgetNameValue,
        actionIdValue,
        notificationTypeValue.map(value => value),
        actionThresholdValue.map(value => value.editable),
        definitionValue.map(value => value.editable),
        executionRoleArnValue.map(value => value),
        approvalModelValue.map(value => value),
        subscribersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def actionIdValue: ActionId
    def notificationTypeValue
        : Option[io.github.vigoo.zioaws.budgets.model.NotificationType]
    def actionThresholdValue
        : Option[io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly]
    def definitionValue
        : Option[io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly]
    def executionRoleArnValue: Option[RoleArn]
    def approvalModelValue
        : Option[io.github.vigoo.zioaws.budgets.model.ApprovalModel]
    def subscribersValue
        : Option[List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, ActionId] = ZIO.succeed(actionIdValue)
    def notificationType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.NotificationType
    ] = AwsError.unwrapOptionField("notificationType", notificationTypeValue)
    def actionThreshold: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly
    ] = AwsError.unwrapOptionField("actionThreshold", actionThresholdValue)
    def definition: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definitionValue)
    def executionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArnValue)
    def approvalModel: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.ApprovalModel
    ] = AwsError.unwrapOptionField("approvalModel", approvalModelValue)
    def subscribers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ]] = AwsError.unwrapOptionField("subscribers", subscribersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest
  ) extends io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def actionIdValue: ActionId = impl.actionId(): ActionId
    override def notificationTypeValue
        : Option[io.github.vigoo.zioaws.budgets.model.NotificationType] = scala
      .Option(impl.notificationType())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.NotificationType.wrap(value)
      )
    override def actionThresholdValue: Option[
      io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly
    ] = scala
      .Option(impl.actionThreshold())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.ActionThreshold.wrap(value)
      )
    override def definitionValue
        : Option[io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly] =
      scala
        .Option(impl.definition())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.Definition.wrap(value)
        )
    override def executionRoleArnValue: Option[RoleArn] =
      scala.Option(impl.executionRoleArn()).map(value => value: RoleArn)
    override def approvalModelValue
        : Option[io.github.vigoo.zioaws.budgets.model.ApprovalModel] = scala
      .Option(impl.approvalModel())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.ApprovalModel.wrap(value)
      )
    override def subscribersValue: Option[
      List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]
    ] = scala
      .Option(impl.subscribers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest
  ): io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionRequest.ReadOnly =
    new Wrapper(impl)
}
