package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.NotificationThreshold
import scala.jdk.CollectionConverters.*
final case class Notification(
    notificationType: io.github.vigoo.zioaws.budgets.model.NotificationType,
    comparisonOperator: io.github.vigoo.zioaws.budgets.model.ComparisonOperator,
    threshold: NotificationThreshold,
    thresholdType: Option[io.github.vigoo.zioaws.budgets.model.ThresholdType] =
      None,
    notificationState: Option[
      io.github.vigoo.zioaws.budgets.model.NotificationState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.Notification = {
    import Notification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Notification
      .builder()
      .notificationType(notificationType.unwrap)
      .comparisonOperator(comparisonOperator.unwrap)
      .threshold(threshold: java.lang.Double)
      .optionallyWith(thresholdType.map(value => value.unwrap))(_.thresholdType)
      .optionallyWith(notificationState.map(value => value.unwrap))(
        _.notificationState
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.Notification.wrap(buildAwsValue())
}
object Notification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.Notification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.Notification =
      io.github.vigoo.zioaws.budgets.model.Notification(
        notificationTypeValue,
        comparisonOperatorValue,
        thresholdValue,
        thresholdTypeValue.map(value => value),
        notificationStateValue.map(value => value)
      )
    def notificationTypeValue
        : io.github.vigoo.zioaws.budgets.model.NotificationType
    def comparisonOperatorValue
        : io.github.vigoo.zioaws.budgets.model.ComparisonOperator
    def thresholdValue: NotificationThreshold
    def thresholdTypeValue
        : Option[io.github.vigoo.zioaws.budgets.model.ThresholdType]
    def notificationStateValue
        : Option[io.github.vigoo.zioaws.budgets.model.NotificationState]
    def notificationType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.NotificationType
    ] = ZIO.succeed(notificationTypeValue)
    def comparisonOperator: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ComparisonOperator
    ] = ZIO.succeed(comparisonOperatorValue)
    def threshold: ZIO[Any, Nothing, NotificationThreshold] =
      ZIO.succeed(thresholdValue)
    def thresholdType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.ThresholdType
    ] = AwsError.unwrapOptionField("thresholdType", thresholdTypeValue)
    def notificationState: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.NotificationState
    ] = AwsError.unwrapOptionField("notificationState", notificationStateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.Notification
  ) extends io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly {
    override def notificationTypeValue
        : io.github.vigoo.zioaws.budgets.model.NotificationType =
      io.github.vigoo.zioaws.budgets.model.NotificationType
        .wrap(impl.notificationType())
    override def comparisonOperatorValue
        : io.github.vigoo.zioaws.budgets.model.ComparisonOperator =
      io.github.vigoo.zioaws.budgets.model.ComparisonOperator
        .wrap(impl.comparisonOperator())
    override def thresholdValue: NotificationThreshold =
      impl.threshold(): NotificationThreshold
    override def thresholdTypeValue
        : Option[io.github.vigoo.zioaws.budgets.model.ThresholdType] = scala
      .Option(impl.thresholdType())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.ThresholdType.wrap(value)
      )
    override def notificationStateValue
        : Option[io.github.vigoo.zioaws.budgets.model.NotificationState] = scala
      .Option(impl.notificationState())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.NotificationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.Notification
  ): io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly = new Wrapper(
    impl
  )
}
