package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionType {
  def unwrap: software.amazon.awssdk.services.budgets.model.ExecutionType
}
object ExecutionType {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.ExecutionType
  ): io.github.vigoo.zioaws.budgets.model.ExecutionType = value match {
    case software.amazon.awssdk.services.budgets.model.ExecutionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ExecutionType.APPROVE_BUDGET_ACTION =>
      val r = APPROVE_BUDGET_ACTION
      r
    case software.amazon.awssdk.services.budgets.model.ExecutionType.RETRY_BUDGET_ACTION =>
      val r = RETRY_BUDGET_ACTION
      r
    case software.amazon.awssdk.services.budgets.model.ExecutionType.REVERSE_BUDGET_ACTION =>
      val r = REVERSE_BUDGET_ACTION
      r
    case software.amazon.awssdk.services.budgets.model.ExecutionType.RESET_BUDGET_ACTION =>
      val r = RESET_BUDGET_ACTION
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ExecutionType =
      software.amazon.awssdk.services.budgets.model.ExecutionType.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVE_BUDGET_ACTION
      extends io.github.vigoo.zioaws.budgets.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ExecutionType =
      software.amazon.awssdk.services.budgets.model.ExecutionType.APPROVE_BUDGET_ACTION
  }
  case object RETRY_BUDGET_ACTION
      extends io.github.vigoo.zioaws.budgets.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ExecutionType =
      software.amazon.awssdk.services.budgets.model.ExecutionType.RETRY_BUDGET_ACTION
  }
  case object REVERSE_BUDGET_ACTION
      extends io.github.vigoo.zioaws.budgets.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ExecutionType =
      software.amazon.awssdk.services.budgets.model.ExecutionType.REVERSE_BUDGET_ACTION
  }
  case object RESET_BUDGET_ACTION
      extends io.github.vigoo.zioaws.budgets.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ExecutionType =
      software.amazon.awssdk.services.budgets.model.ExecutionType.RESET_BUDGET_ACTION
  }
}
