package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriberRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    notification: io.github.vigoo.zioaws.budgets.model.Notification,
    oldSubscriber: io.github.vigoo.zioaws.budgets.model.Subscriber,
    newSubscriber: io.github.vigoo.zioaws.budgets.model.Subscriber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest = {
    import UpdateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .notification(notification.buildAwsValue())
      .oldSubscriber(oldSubscriber.buildAwsValue())
      .newSubscriber(newSubscriber.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.UpdateSubscriberRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.UpdateSubscriberRequest
      .wrap(buildAwsValue())
}
object UpdateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.UpdateSubscriberRequest =
      io.github.vigoo.zioaws.budgets.model.UpdateSubscriberRequest(
        accountIdValue,
        budgetNameValue,
        notificationValue.editable,
        oldSubscriberValue.editable,
        newSubscriberValue.editable
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def oldSubscriberValue
        : io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    def newSubscriberValue
        : io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(notificationValue)
    def oldSubscriber: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ] = ZIO.succeed(oldSubscriberValue)
    def newSubscriber: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ] = ZIO.succeed(newSubscriberValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest
  ) extends io.github.vigoo.zioaws.budgets.model.UpdateSubscriberRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.notification())
    override def oldSubscriberValue
        : io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(impl.oldSubscriber())
    override def newSubscriberValue
        : io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(impl.newSubscriber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest
  ): io.github.vigoo.zioaws.budgets.model.UpdateSubscriberRequest.ReadOnly =
    new Wrapper(impl)
}
