package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class UpdateNotificationRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    oldNotification: io.github.vigoo.zioaws.budgets.model.Notification,
    newNotification: io.github.vigoo.zioaws.budgets.model.Notification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest = {
    import UpdateNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .oldNotification(oldNotification.buildAwsValue())
      .newNotification(newNotification.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.UpdateNotificationRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.UpdateNotificationRequest
      .wrap(buildAwsValue())
}
object UpdateNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.UpdateNotificationRequest =
      io.github.vigoo.zioaws.budgets.model.UpdateNotificationRequest(
        accountIdValue,
        budgetNameValue,
        oldNotificationValue.editable,
        newNotificationValue.editable
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def oldNotificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def newNotificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def oldNotification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(oldNotificationValue)
    def newNotification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(newNotificationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest
  ) extends io.github.vigoo.zioaws.budgets.model.UpdateNotificationRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def oldNotificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.oldNotification())
    override def newNotificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.newNotification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest
  ): io.github.vigoo.zioaws.budgets.model.UpdateNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
