package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.SubscriberAddress
import scala.jdk.CollectionConverters.*
final case class Subscriber(
    subscriptionType: io.github.vigoo.zioaws.budgets.model.SubscriptionType,
    address: SubscriberAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.Subscriber = {
    import Subscriber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Subscriber
      .builder()
      .subscriptionType(subscriptionType.unwrap)
      .address(address: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(buildAwsValue())
}
object Subscriber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.Subscriber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.Subscriber =
      io.github.vigoo.zioaws.budgets.model
        .Subscriber(subscriptionTypeValue, addressValue)
    def subscriptionTypeValue
        : io.github.vigoo.zioaws.budgets.model.SubscriptionType
    def addressValue: SubscriberAddress
    def subscriptionType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.SubscriptionType
    ] = ZIO.succeed(subscriptionTypeValue)
    def address: ZIO[Any, Nothing, SubscriberAddress] =
      ZIO.succeed(addressValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.Subscriber
  ) extends io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly {
    override def subscriptionTypeValue
        : io.github.vigoo.zioaws.budgets.model.SubscriptionType =
      io.github.vigoo.zioaws.budgets.model.SubscriptionType
        .wrap(impl.subscriptionType())
    override def addressValue: SubscriberAddress =
      impl.address(): SubscriberAddress
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.Subscriber
  ): io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly = new Wrapper(
    impl
  )
}
