package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.UnitValue
import scala.jdk.CollectionConverters.*
final case class Spend(amount: scala.math.BigDecimal, unit: UnitValue) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Spend = {
    import Spend.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Spend
      .builder()
      .amount(amount.bigDecimal)
      .unit(unit: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.Spend.wrap(buildAwsValue())
}
object Spend {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.budgets.model.Spend] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.Spend =
      io.github.vigoo.zioaws.budgets.model.Spend(amountValue, unitValue)
    def amountValue: scala.math.BigDecimal
    def unitValue: UnitValue
    def amount: ZIO[Any, Nothing, scala.math.BigDecimal] =
      ZIO.succeed(amountValue)
    def unit: ZIO[Any, Nothing, UnitValue] = ZIO.succeed(unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.Spend
  ) extends io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly {
    override def amountValue: scala.math.BigDecimal =
      impl.amount(): scala.math.BigDecimal
    override def unitValue: UnitValue = impl.unit(): UnitValue
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.Spend
  ): io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly = new Wrapper(impl)
}
