package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{
  ActionId,
  BudgetName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DeleteBudgetActionRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    actionId: ActionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest = {
    import DeleteBudgetActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .actionId(actionId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionRequest
      .wrap(buildAwsValue())
}
object DeleteBudgetActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionRequest =
      io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionRequest(
        accountIdValue,
        budgetNameValue,
        actionIdValue
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def actionIdValue: ActionId
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, ActionId] = ZIO.succeed(actionIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def actionIdValue: ActionId = impl.actionId(): ActionId
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest
  ): io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionRequest.ReadOnly =
    new Wrapper(impl)
}
