package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class CreateBudgetRequest(
    accountId: AccountId,
    budget: io.github.vigoo.zioaws.budgets.model.Budget,
    notificationsWithSubscribers: Option[
      Iterable[io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.CreateBudgetRequest = {
    import CreateBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CreateBudgetRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budget(budget.buildAwsValue())
      .optionallyWith(
        notificationsWithSubscribers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notificationsWithSubscribers)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.CreateBudgetRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.CreateBudgetRequest
      .wrap(buildAwsValue())
}
object CreateBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.CreateBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.CreateBudgetRequest =
      io.github.vigoo.zioaws.budgets.model.CreateBudgetRequest(
        accountIdValue,
        budgetValue.editable,
        notificationsWithSubscribersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def accountIdValue: AccountId
    def budgetValue: io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    def notificationsWithSubscribersValue: Option[List[
      io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers.ReadOnly
    ]]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budget: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    ] = ZIO.succeed(budgetValue)
    def notificationsWithSubscribers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "notificationsWithSubscribers",
      notificationsWithSubscribersValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.CreateBudgetRequest
  ) extends io.github.vigoo.zioaws.budgets.model.CreateBudgetRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetValue
        : io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Budget.wrap(impl.budget())
    override def notificationsWithSubscribersValue: Option[List[
      io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers.ReadOnly
    ]] = scala
      .Option(impl.notificationsWithSubscribers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.CreateBudgetRequest
  ): io.github.vigoo.zioaws.budgets.model.CreateBudgetRequest.ReadOnly =
    new Wrapper(impl)
}
