package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateSubscriberRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, notification: Notification, oldSubscriber: Subscriber, newSubscriber: Subscriber) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest = {
    import UpdateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).notification(notification.buildAwsValue()).oldSubscriber(oldSubscriber.buildAwsValue()).newSubscriber(newSubscriber.buildAwsValue()).build()
  }
  def asReadOnly: UpdateSubscriberRequest.ReadOnly = UpdateSubscriberRequest.wrap(buildAwsValue())
}
object UpdateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateSubscriberRequest = UpdateSubscriberRequest(accountIdValue, budgetNameValue, notificationValue.editable, oldSubscriberValue.editable, newSubscriberValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def notificationValue: Notification.ReadOnly
    def oldSubscriberValue: Subscriber.ReadOnly
    def newSubscriberValue: Subscriber.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(notificationValue)
    def oldSubscriber: ZIO[Any, Nothing, Subscriber.ReadOnly] = ZIO.succeed(oldSubscriberValue)
    def newSubscriber: ZIO[Any, Nothing, Subscriber.ReadOnly] = ZIO.succeed(newSubscriberValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest) extends UpdateSubscriberRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def notificationValue: Notification.ReadOnly = Notification.wrap(impl.notification())
    override def oldSubscriberValue: Subscriber.ReadOnly = Subscriber.wrap(impl.oldSubscriber())
    override def newSubscriberValue: Subscriber.ReadOnly = Subscriber.wrap(impl.newSubscriber())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest): ReadOnly = new Wrapper(impl)
}