package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Spend(amount: BigDecimal, unit: primitives.UnitValue) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Spend = {
    import Spend.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Spend.builder().amount(amount.bigDecimal).unit(unit: java.lang.String).build()
  }
  def asReadOnly: Spend.ReadOnly = Spend.wrap(buildAwsValue())
}
object Spend {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.Spend] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Spend = Spend(amountValue, unitValue)
    def amountValue: BigDecimal
    def unitValue: primitives.UnitValue
    def amount: ZIO[Any, Nothing, BigDecimal] = ZIO.succeed(amountValue)
    def unit: ZIO[Any, Nothing, primitives.UnitValue] = ZIO.succeed(unitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.Spend) extends Spend.ReadOnly {
    override def amountValue: BigDecimal = impl.amount(): BigDecimal
    override def unitValue: primitives.UnitValue = impl.unit(): primitives.UnitValue
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.Spend): ReadOnly = new Wrapper(impl)
}