package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CalculatedSpend(actualSpend: Spend, forecastedSpend: scala.Option[Spend] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.CalculatedSpend = {
    import CalculatedSpend.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CalculatedSpend.builder().actualSpend(actualSpend.buildAwsValue()).optionallyWith(forecastedSpend.map(value => value.buildAwsValue()))(_.forecastedSpend).build()
  }
  def asReadOnly: CalculatedSpend.ReadOnly = CalculatedSpend.wrap(buildAwsValue())
}
object CalculatedSpend {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.CalculatedSpend] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CalculatedSpend = CalculatedSpend(actualSpendValue.editable, forecastedSpendValue.map(value => value.editable))
    def actualSpendValue: Spend.ReadOnly
    def forecastedSpendValue: scala.Option[Spend.ReadOnly]
    def actualSpend: ZIO[Any, Nothing, Spend.ReadOnly] = ZIO.succeed(actualSpendValue)
    def forecastedSpend: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Spend.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forecastedSpend", forecastedSpendValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.CalculatedSpend) extends CalculatedSpend.ReadOnly {
    override def actualSpendValue: Spend.ReadOnly = Spend.wrap(impl.actualSpend())
    override def forecastedSpendValue: scala.Option[Spend.ReadOnly] = scala.Option(impl.forecastedSpend()).map(value => Spend.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.CalculatedSpend): ReadOnly = new Wrapper(impl)
}