package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters.*
final case class CostTypes(
    includeTax: Option[NullableBoolean] = None,
    includeSubscription: Option[NullableBoolean] = None,
    useBlended: Option[NullableBoolean] = None,
    includeRefund: Option[NullableBoolean] = None,
    includeCredit: Option[NullableBoolean] = None,
    includeUpfront: Option[NullableBoolean] = None,
    includeRecurring: Option[NullableBoolean] = None,
    includeOtherSubscription: Option[NullableBoolean] = None,
    includeSupport: Option[NullableBoolean] = None,
    includeDiscount: Option[NullableBoolean] = None,
    useAmortized: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.CostTypes = {
    import CostTypes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CostTypes
      .builder()
      .optionallyWith(includeTax.map(value => value: java.lang.Boolean))(
        _.includeTax
      )
      .optionallyWith(
        includeSubscription.map(value => value: java.lang.Boolean)
      )(_.includeSubscription)
      .optionallyWith(useBlended.map(value => value: java.lang.Boolean))(
        _.useBlended
      )
      .optionallyWith(includeRefund.map(value => value: java.lang.Boolean))(
        _.includeRefund
      )
      .optionallyWith(includeCredit.map(value => value: java.lang.Boolean))(
        _.includeCredit
      )
      .optionallyWith(includeUpfront.map(value => value: java.lang.Boolean))(
        _.includeUpfront
      )
      .optionallyWith(includeRecurring.map(value => value: java.lang.Boolean))(
        _.includeRecurring
      )
      .optionallyWith(
        includeOtherSubscription.map(value => value: java.lang.Boolean)
      )(_.includeOtherSubscription)
      .optionallyWith(includeSupport.map(value => value: java.lang.Boolean))(
        _.includeSupport
      )
      .optionallyWith(includeDiscount.map(value => value: java.lang.Boolean))(
        _.includeDiscount
      )
      .optionallyWith(useAmortized.map(value => value: java.lang.Boolean))(
        _.useAmortized
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.CostTypes.wrap(buildAwsValue())
}
object CostTypes {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.budgets.model.CostTypes] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.CostTypes =
      io.github.vigoo.zioaws.budgets.model.CostTypes(
        includeTaxValue.map(value => value),
        includeSubscriptionValue.map(value => value),
        useBlendedValue.map(value => value),
        includeRefundValue.map(value => value),
        includeCreditValue.map(value => value),
        includeUpfrontValue.map(value => value),
        includeRecurringValue.map(value => value),
        includeOtherSubscriptionValue.map(value => value),
        includeSupportValue.map(value => value),
        includeDiscountValue.map(value => value),
        useAmortizedValue.map(value => value)
      )
    def includeTaxValue: Option[NullableBoolean]
    def includeSubscriptionValue: Option[NullableBoolean]
    def useBlendedValue: Option[NullableBoolean]
    def includeRefundValue: Option[NullableBoolean]
    def includeCreditValue: Option[NullableBoolean]
    def includeUpfrontValue: Option[NullableBoolean]
    def includeRecurringValue: Option[NullableBoolean]
    def includeOtherSubscriptionValue: Option[NullableBoolean]
    def includeSupportValue: Option[NullableBoolean]
    def includeDiscountValue: Option[NullableBoolean]
    def useAmortizedValue: Option[NullableBoolean]
    def includeTax: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeTax", includeTaxValue)
    def includeSubscription: ZIO[Any, AwsError, NullableBoolean] = AwsError
      .unwrapOptionField("includeSubscription", includeSubscriptionValue)
    def useBlended: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("useBlended", useBlendedValue)
    def includeRefund: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeRefund", includeRefundValue)
    def includeCredit: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeCredit", includeCreditValue)
    def includeUpfront: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeUpfront", includeUpfrontValue)
    def includeRecurring: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeRecurring", includeRecurringValue)
    def includeOtherSubscription: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "includeOtherSubscription",
        includeOtherSubscriptionValue
      )
    def includeSupport: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeSupport", includeSupportValue)
    def includeDiscount: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeDiscount", includeDiscountValue)
    def useAmortized: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("useAmortized", useAmortizedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.CostTypes
  ) extends io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly {
    override def includeTaxValue: Option[NullableBoolean] =
      scala.Option(impl.includeTax()).map(value => value: NullableBoolean)
    override def includeSubscriptionValue: Option[NullableBoolean] = scala
      .Option(impl.includeSubscription())
      .map(value => value: NullableBoolean)
    override def useBlendedValue: Option[NullableBoolean] =
      scala.Option(impl.useBlended()).map(value => value: NullableBoolean)
    override def includeRefundValue: Option[NullableBoolean] =
      scala.Option(impl.includeRefund()).map(value => value: NullableBoolean)
    override def includeCreditValue: Option[NullableBoolean] =
      scala.Option(impl.includeCredit()).map(value => value: NullableBoolean)
    override def includeUpfrontValue: Option[NullableBoolean] =
      scala.Option(impl.includeUpfront()).map(value => value: NullableBoolean)
    override def includeRecurringValue: Option[NullableBoolean] =
      scala.Option(impl.includeRecurring()).map(value => value: NullableBoolean)
    override def includeOtherSubscriptionValue: Option[NullableBoolean] = scala
      .Option(impl.includeOtherSubscription())
      .map(value => value: NullableBoolean)
    override def includeSupportValue: Option[NullableBoolean] =
      scala.Option(impl.includeSupport()).map(value => value: NullableBoolean)
    override def includeDiscountValue: Option[NullableBoolean] =
      scala.Option(impl.includeDiscount()).map(value => value: NullableBoolean)
    override def useAmortizedValue: Option[NullableBoolean] =
      scala.Option(impl.useAmortized()).map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.CostTypes
  ): io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly = new Wrapper(impl)
}
