package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{
  RoleArn,
  BudgetName,
  ActionId
}
import scala.jdk.CollectionConverters.*
final case class Action(
    actionId: ActionId,
    budgetName: BudgetName,
    notificationType: io.github.vigoo.zioaws.budgets.model.NotificationType,
    actionType: io.github.vigoo.zioaws.budgets.model.ActionType,
    actionThreshold: io.github.vigoo.zioaws.budgets.model.ActionThreshold,
    definition: io.github.vigoo.zioaws.budgets.model.Definition,
    executionRoleArn: RoleArn,
    approvalModel: io.github.vigoo.zioaws.budgets.model.ApprovalModel,
    status: io.github.vigoo.zioaws.budgets.model.ActionStatus,
    subscribers: Iterable[io.github.vigoo.zioaws.budgets.model.Subscriber]
) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Action
      .builder()
      .actionId(actionId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .notificationType(notificationType.unwrap)
      .actionType(actionType.unwrap)
      .actionThreshold(actionThreshold.buildAwsValue())
      .definition(definition.buildAwsValue())
      .executionRoleArn(executionRoleArn: java.lang.String)
      .approvalModel(approvalModel.unwrap)
      .status(status.unwrap)
      .subscribers(subscribers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.Action.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.budgets.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.Action =
      io.github.vigoo.zioaws.budgets.model.Action(
        actionIdValue,
        budgetNameValue,
        notificationTypeValue,
        actionTypeValue,
        actionThresholdValue.editable,
        definitionValue.editable,
        executionRoleArnValue,
        approvalModelValue,
        statusValue,
        subscribersValue.map { item =>
          item.editable
        }
      )
    def actionIdValue: ActionId
    def budgetNameValue: BudgetName
    def notificationTypeValue
        : io.github.vigoo.zioaws.budgets.model.NotificationType
    def actionTypeValue: io.github.vigoo.zioaws.budgets.model.ActionType
    def actionThresholdValue
        : io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly
    def definitionValue
        : io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly
    def executionRoleArnValue: RoleArn
    def approvalModelValue: io.github.vigoo.zioaws.budgets.model.ApprovalModel
    def statusValue: io.github.vigoo.zioaws.budgets.model.ActionStatus
    def subscribersValue
        : List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]
    def actionId: ZIO[Any, Nothing, ActionId] = ZIO.succeed(actionIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def notificationType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.NotificationType
    ] = ZIO.succeed(notificationTypeValue)
    def actionType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.budgets.model.ActionType] =
      ZIO.succeed(actionTypeValue)
    def actionThreshold: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly
    ] = ZIO.succeed(actionThresholdValue)
    def definition: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly
    ] = ZIO.succeed(definitionValue)
    def executionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(executionRoleArnValue)
    def approvalModel: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ApprovalModel
    ] = ZIO.succeed(approvalModelValue)
    def status
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.budgets.model.ActionStatus] =
      ZIO.succeed(statusValue)
    def subscribers: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ]] = ZIO.succeed(subscribersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.Action
  ) extends io.github.vigoo.zioaws.budgets.model.Action.ReadOnly {
    override def actionIdValue: ActionId = impl.actionId(): ActionId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def notificationTypeValue
        : io.github.vigoo.zioaws.budgets.model.NotificationType =
      io.github.vigoo.zioaws.budgets.model.NotificationType
        .wrap(impl.notificationType())
    override def actionTypeValue
        : io.github.vigoo.zioaws.budgets.model.ActionType =
      io.github.vigoo.zioaws.budgets.model.ActionType.wrap(impl.actionType())
    override def actionThresholdValue
        : io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.ActionThreshold
        .wrap(impl.actionThreshold())
    override def definitionValue
        : io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Definition.wrap(impl.definition())
    override def executionRoleArnValue: RoleArn =
      impl.executionRoleArn(): RoleArn
    override def approvalModelValue
        : io.github.vigoo.zioaws.budgets.model.ApprovalModel =
      io.github.vigoo.zioaws.budgets.model.ApprovalModel
        .wrap(impl.approvalModel())
    override def statusValue
        : io.github.vigoo.zioaws.budgets.model.ActionStatus =
      io.github.vigoo.zioaws.budgets.model.ActionStatus.wrap(impl.status())
    override def subscribersValue
        : List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly] = impl
      .subscribers()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.Action
  ): io.github.vigoo.zioaws.budgets.model.Action.ReadOnly = new Wrapper(impl)
}
