package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{InstanceId, Region}
import scala.jdk.CollectionConverters.*
final case class SsmActionDefinition(
    actionSubType: io.github.vigoo.zioaws.budgets.model.ActionSubType,
    region: Region,
    instanceIds: Iterable[InstanceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.SsmActionDefinition = {
    import SsmActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.SsmActionDefinition
      .builder()
      .actionSubType(actionSubType.unwrap)
      .region(region: java.lang.String)
      .instanceIds(instanceIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.SsmActionDefinition
      .wrap(buildAwsValue())
}
object SsmActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.SsmActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.SsmActionDefinition =
      io.github.vigoo.zioaws.budgets.model
        .SsmActionDefinition(actionSubTypeValue, regionValue, instanceIdsValue)
    def actionSubTypeValue: io.github.vigoo.zioaws.budgets.model.ActionSubType
    def regionValue: Region
    def instanceIdsValue: List[InstanceId]
    def actionSubType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ActionSubType
    ] = ZIO.succeed(actionSubTypeValue)
    def region: ZIO[Any, Nothing, Region] = ZIO.succeed(regionValue)
    def instanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIdsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.SsmActionDefinition
  ) extends io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.ReadOnly {
    override def actionSubTypeValue
        : io.github.vigoo.zioaws.budgets.model.ActionSubType =
      io.github.vigoo.zioaws.budgets.model.ActionSubType
        .wrap(impl.actionSubType())
    override def regionValue: Region = impl.region(): Region
    override def instanceIdsValue: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        item: InstanceId
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.SsmActionDefinition
  ): io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.ReadOnly =
    new Wrapper(impl)
}
