package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{
  ActionId,
  BudgetName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class ExecuteBudgetActionRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    actionId: ActionId,
    executionType: io.github.vigoo.zioaws.budgets.model.ExecutionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest = {
    import ExecuteBudgetActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .actionId(actionId: java.lang.String)
      .executionType(executionType.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionRequest
      .wrap(buildAwsValue())
}
object ExecuteBudgetActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionRequest =
      io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionRequest(
        accountIdValue,
        budgetNameValue,
        actionIdValue,
        executionTypeValue
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def actionIdValue: ActionId
    def executionTypeValue: io.github.vigoo.zioaws.budgets.model.ExecutionType
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, ActionId] = ZIO.succeed(actionIdValue)
    def executionType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ExecutionType
    ] = ZIO.succeed(executionTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest
  ) extends io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def actionIdValue: ActionId = impl.actionId(): ActionId
    override def executionTypeValue
        : io.github.vigoo.zioaws.budgets.model.ExecutionType =
      io.github.vigoo.zioaws.budgets.model.ExecutionType
        .wrap(impl.executionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest
  ): io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionRequest.ReadOnly =
    new Wrapper(impl)
}
