package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetsResponse(
    budgets: Option[Iterable[io.github.vigoo.zioaws.budgets.model.Budget]] =
      None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse = {
    import DescribeBudgetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse
      .builder()
      .optionallyWith(
        budgets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetsResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetsResponse
      .wrap(buildAwsValue())
}
object DescribeBudgetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.DescribeBudgetsResponse =
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetsResponse(
        budgetsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def budgetsValue
        : Option[List[io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly]]
    def nextTokenValue: Option[GenericString]
    def budgets: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    ]] = AwsError.unwrapOptionField("budgets", budgetsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetsResponse.ReadOnly {
    override def budgetsValue
        : Option[List[io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly]] =
      scala
        .Option(impl.budgets())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.budgets.model.Budget.wrap(item)
          }.toList
        )
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetsResponse.ReadOnly =
    new Wrapper(impl)
}
