package io.github.vigoo.zioaws.budgets.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  GenericString,
  MaxResults,
  BudgetName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetPerformanceHistoryRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    timePeriod: Option[io.github.vigoo.zioaws.budgets.model.TimePeriod] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest = {
    import DescribeBudgetPerformanceHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryRequest
      .wrap(buildAwsValue())
}
object DescribeBudgetPerformanceHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryRequest =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetPerformanceHistoryRequest(
          accountIdValue,
          budgetNameValue,
          timePeriodValue.map(value => value.editable),
          maxResultsValue.map(value => value),
          nextTokenValue.map(value => value)
        )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly]
    def maxResultsValue: Option[MaxResults]
    def nextTokenValue: Option[GenericString]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly] =
      scala
        .Option(impl.timePeriod())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.TimePeriod.wrap(value)
        )
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
