package io.github.vigoo.zioaws.budgets.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  AccountId,
  ActionId,
  GenericString,
  BudgetName,
  MaxResults
}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetActionHistoriesRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    actionId: ActionId,
    timePeriod: Option[io.github.vigoo.zioaws.budgets.model.TimePeriod] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest = {
    import DescribeBudgetActionHistoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .actionId(actionId: java.lang.String)
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesRequest
      .wrap(buildAwsValue())
}
object DescribeBudgetActionHistoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesRequest =
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesRequest(
        accountIdValue,
        budgetNameValue,
        actionIdValue,
        timePeriodValue.map(value => value.editable),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def actionIdValue: ActionId
    def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly]
    def maxResultsValue: Option[MaxResults]
    def nextTokenValue: Option[GenericString]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, ActionId] = ZIO.succeed(actionIdValue)
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def actionIdValue: ActionId = impl.actionId(): ActionId
    override def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly] =
      scala
        .Option(impl.timePeriod())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.TimePeriod.wrap(value)
        )
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesRequest.ReadOnly =
    new Wrapper(impl)
}
