package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NotificationWithSubscribers(
    notification: io.github.vigoo.zioaws.budgets.model.Notification,
    subscribers: Iterable[io.github.vigoo.zioaws.budgets.model.Subscriber]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers = {
    import NotificationWithSubscribers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers
      .builder()
      .notification(notification.buildAwsValue())
      .subscribers(subscribers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers
      .wrap(buildAwsValue())
}
object NotificationWithSubscribers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers =
      io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers(
        notificationValue.editable,
        subscribersValue.map { item =>
          item.editable
        }
      )
    def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def subscribersValue
        : List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]
    def notification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(notificationValue)
    def subscribers: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ]] = ZIO.succeed(subscribersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers
  ) extends io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers.ReadOnly {
    override def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.notification())
    override def subscribersValue
        : List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly] = impl
      .subscribers()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers
  ): io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers.ReadOnly =
    new Wrapper(impl)
}
