package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationState {
  def unwrap: software.amazon.awssdk.services.budgets.model.NotificationState
}
object NotificationState {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.NotificationState
  ): io.github.vigoo.zioaws.budgets.model.NotificationState = value match {
    case software.amazon.awssdk.services.budgets.model.NotificationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.NotificationState.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.budgets.model.NotificationState.ALARM =>
      val r = ALARM
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.NotificationState {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.NotificationState =
      software.amazon.awssdk.services.budgets.model.NotificationState.UNKNOWN_TO_SDK_VERSION
  }
  case object OK
      extends io.github.vigoo.zioaws.budgets.model.NotificationState {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.NotificationState =
      software.amazon.awssdk.services.budgets.model.NotificationState.OK
  }
  case object ALARM
      extends io.github.vigoo.zioaws.budgets.model.NotificationState {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.NotificationState =
      software.amazon.awssdk.services.budgets.model.NotificationState.ALARM
  }
}
