package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class DescribeNotificationsForBudgetResponse(
    notifications: Option[
      Iterable[io.github.vigoo.zioaws.budgets.model.Notification]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse = {
    import DescribeNotificationsForBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse
      .builder()
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeNotificationsForBudgetResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeNotificationsForBudgetResponse
      .wrap(buildAwsValue())
}
object DescribeNotificationsForBudgetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeNotificationsForBudgetResponse =
      io.github.vigoo.zioaws.budgets.model
        .DescribeNotificationsForBudgetResponse(
          notificationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def notificationsValue: Option[
      List[io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly]
    ]
    def nextTokenValue: Option[GenericString]
    def notifications: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notificationsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeNotificationsForBudgetResponse.ReadOnly {
    override def notificationsValue: Option[
      List[io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly]
    ] = scala
      .Option(impl.notifications())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.budgets.model.Notification.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeNotificationsForBudgetResponse.ReadOnly =
    new Wrapper(impl)
}
