package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetRequest(
    accountId: AccountId,
    budgetName: BudgetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest = {
    import DescribeBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetRequest
      .wrap(buildAwsValue())
}
object DescribeBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.DescribeBudgetRequest =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetRequest(accountIdValue, budgetNameValue)
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetRequest.ReadOnly =
    new Wrapper(impl)
}
