package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetActionsForBudgetResponse(
    actions: Iterable[io.github.vigoo.zioaws.budgets.model.Action],
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse = {
    import DescribeBudgetActionsForBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse
      .builder()
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetResponse
      .wrap(buildAwsValue())
}
object DescribeBudgetActionsForBudgetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetResponse =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetActionsForBudgetResponse(
          actionsValue.map { item =>
            item.editable
          },
          nextTokenValue.map(value => value)
        )
    def actionsValue: List[io.github.vigoo.zioaws.budgets.model.Action.ReadOnly]
    def nextTokenValue: Option[GenericString]
    def actions: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ]] = ZIO.succeed(actionsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetResponse.ReadOnly {
    override def actionsValue
        : List[io.github.vigoo.zioaws.budgets.model.Action.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.budgets.model.Action.wrap(item)
      }
      .toList
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetResponse.ReadOnly =
    new Wrapper(impl)
}
