package io.github.vigoo.zioaws.budgets.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  GenericString,
  MaxResults,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetActionsForAccountRequest(
    accountId: AccountId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest = {
    import DescribeBudgetActionsForAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForAccountRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForAccountRequest
      .wrap(buildAwsValue())
}
object DescribeBudgetActionsForAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForAccountRequest =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetActionsForAccountRequest(
          accountIdValue,
          maxResultsValue.map(value => value),
          nextTokenValue.map(value => value)
        )
    def accountIdValue: AccountId
    def maxResultsValue: Option[MaxResults]
    def nextTokenValue: Option[GenericString]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForAccountRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForAccountRequest.ReadOnly =
    new Wrapper(impl)
}
