package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class DeleteNotificationRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    notification: io.github.vigoo.zioaws.budgets.model.Notification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest = {
    import DeleteNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .notification(notification.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DeleteNotificationRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DeleteNotificationRequest
      .wrap(buildAwsValue())
}
object DeleteNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DeleteNotificationRequest =
      io.github.vigoo.zioaws.budgets.model.DeleteNotificationRequest(
        accountIdValue,
        budgetNameValue,
        notificationValue.editable
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(notificationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DeleteNotificationRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.notification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest
  ): io.github.vigoo.zioaws.budgets.model.DeleteNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
