package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Definition(
    iamActionDefinition: Option[
      io.github.vigoo.zioaws.budgets.model.IamActionDefinition
    ] = None,
    scpActionDefinition: Option[
      io.github.vigoo.zioaws.budgets.model.ScpActionDefinition
    ] = None,
    ssmActionDefinition: Option[
      io.github.vigoo.zioaws.budgets.model.SsmActionDefinition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.Definition = {
    import Definition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Definition
      .builder()
      .optionallyWith(iamActionDefinition.map(value => value.buildAwsValue()))(
        _.iamActionDefinition
      )
      .optionallyWith(scpActionDefinition.map(value => value.buildAwsValue()))(
        _.scpActionDefinition
      )
      .optionallyWith(ssmActionDefinition.map(value => value.buildAwsValue()))(
        _.ssmActionDefinition
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.Definition.wrap(buildAwsValue())
}
object Definition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.Definition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.Definition =
      io.github.vigoo.zioaws.budgets.model.Definition(
        iamActionDefinitionValue.map(value => value.editable),
        scpActionDefinitionValue.map(value => value.editable),
        ssmActionDefinitionValue.map(value => value.editable)
      )
    def iamActionDefinitionValue: Option[
      io.github.vigoo.zioaws.budgets.model.IamActionDefinition.ReadOnly
    ]
    def scpActionDefinitionValue: Option[
      io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.ReadOnly
    ]
    def ssmActionDefinitionValue: Option[
      io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.ReadOnly
    ]
    def iamActionDefinition: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.IamActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "iamActionDefinition",
      iamActionDefinitionValue
    )
    def scpActionDefinition: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scpActionDefinition",
      scpActionDefinitionValue
    )
    def ssmActionDefinition: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ssmActionDefinition",
      ssmActionDefinitionValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.Definition
  ) extends io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly {
    override def iamActionDefinitionValue: Option[
      io.github.vigoo.zioaws.budgets.model.IamActionDefinition.ReadOnly
    ] = scala
      .Option(impl.iamActionDefinition())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.IamActionDefinition.wrap(value)
      )
    override def scpActionDefinitionValue: Option[
      io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.ReadOnly
    ] = scala
      .Option(impl.scpActionDefinition())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.wrap(value)
      )
    override def ssmActionDefinitionValue: Option[
      io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.ReadOnly
    ] = scala
      .Option(impl.ssmActionDefinition())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.SsmActionDefinition.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.Definition
  ): io.github.vigoo.zioaws.budgets.model.Definition.ReadOnly = new Wrapper(
    impl
  )
}
