package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class CreateNotificationRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    notification: io.github.vigoo.zioaws.budgets.model.Notification,
    subscribers: Iterable[io.github.vigoo.zioaws.budgets.model.Subscriber]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.CreateNotificationRequest = {
    import CreateNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CreateNotificationRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .notification(notification.buildAwsValue())
      .subscribers(subscribers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.CreateNotificationRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.CreateNotificationRequest
      .wrap(buildAwsValue())
}
object CreateNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.CreateNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.CreateNotificationRequest =
      io.github.vigoo.zioaws.budgets.model.CreateNotificationRequest(
        accountIdValue,
        budgetNameValue,
        notificationValue.editable,
        subscribersValue.map { item =>
          item.editable
        }
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def subscribersValue
        : List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(notificationValue)
    def subscribers: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ]] = ZIO.succeed(subscribersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.CreateNotificationRequest
  ) extends io.github.vigoo.zioaws.budgets.model.CreateNotificationRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.notification())
    override def subscribersValue
        : List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly] = impl
      .subscribers()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.CreateNotificationRequest
  ): io.github.vigoo.zioaws.budgets.model.CreateNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
