package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class ActionHistoryDetails(
    message: GenericString,
    action: io.github.vigoo.zioaws.budgets.model.Action
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.ActionHistoryDetails = {
    import ActionHistoryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ActionHistoryDetails
      .builder()
      .message(message: java.lang.String)
      .action(action.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails
      .wrap(buildAwsValue())
}
object ActionHistoryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.ActionHistoryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails =
      io.github.vigoo.zioaws.budgets.model
        .ActionHistoryDetails(messageValue, actionValue.editable)
    def messageValue: GenericString
    def actionValue: io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    def message: ZIO[Any, Nothing, GenericString] = ZIO.succeed(messageValue)
    def action: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ] = ZIO.succeed(actionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.ActionHistoryDetails
  ) extends io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails.ReadOnly {
    override def messageValue: GenericString = impl.message(): GenericString
    override def actionValue
        : io.github.vigoo.zioaws.budgets.model.Action.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Action.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.ActionHistoryDetails
  ): io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails.ReadOnly =
    new Wrapper(impl)
}
